/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/add-patient-dialog.js":
/*!***********************************!*\
  !*** ./src/add-patient-dialog.js ***!
  \***********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"AddPatientDialog\": function() { return /* binding */ AddPatientDialog; }\n/* harmony export */ });\n/**\n * Javascript Controller for the Add Patient Dialog window in the telehealth conference room.\n *\n * @package openemr\n * @link      http://www.open-emr.org\n * @author    Stephen Nielson <snielson@discoverandchange.com>\n * @copyright Copyright (c) 2023 Comlink Inc <https://comlinkinc.com/>\n * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3\n */\n\nclass AddPatientDialog\n{\n    /**\n     *\n     * @type {bootstrap.Modal}\n     */\n    modal = null;\n\n    /**\n     *\n     * @type HTMLElement\n     */\n    container = null;\n\n    /**\n     *\n     * @type {number}\n     */\n    pc_eid = null;\n\n    /**\n     *\n     * @type {string}\n     */\n    scriptLocation = null;\n\n    /**\n     * Address of the FHIR api endpoint\n     * @type string\n     */\n    fhirLocation = null;\n\n    /**\n     *\n     * @type {function}\n     */\n    closeCallback = null;\n\n    /**\n     * Key value dictionary of the language translations\n     * @type {array}\n     * @private\n     */\n    __translations = null;\n\n    /**\n     * Used for making unique modal ids\n     * @type {number}\n     * @private\n     */\n    __idx = 0;\n\n    /**\n     * Cross Site Request Forgery token used to communicate with the internal API\n     * @type {null}\n     * @private\n     */\n    __apiCSRFToken = null;\n\n    /**\n     * The current screen we are displaying inside the dialog\n     * @type {string}\n     * @private\n     */\n    __currentScreen = null;\n\n    /**\n     * The caller settings received from the server that should be used for the telehealth session call\n     * @type {object}\n     * @private\n     */\n    __updatedCallerSettings = null;\n\n    /**\n     * The list of participants that are in the call\n     * @type {object}\n     * @private\n     */\n    __participantList = null;\n\n    /**\n     * Boolean that the DOM interface needs to be updated with the participant list changes.\n     * @type {boolean}\n     * @private\n     */\n    __updateParticipants = false;\n\n    constructor(apiCSRFToken, translations, pc_eid, scriptLocation, fhirLocation, participantList, closeCallback) {\n        this.pc_eid = pc_eid;\n        this.scriptLocation = scriptLocation;\n        this.fhirLocation = fhirLocation;\n        this.closeCallback = closeCallback;\n        this.__translations = translations;\n        this.__apiCSRFToken = apiCSRFToken;\n\n        this.__participantList = (participantList || []).filter(pl => pl.role !== 'provider');\n        this.__updateParticipants = false;\n    }\n\n    cancelDialog() {\n        // just have us call the close dialog piece.\n        this.closeDialogAndSendCallerSettings();\n\n    }\n\n    sendSaveParticipant(saveData) {\n        let postData = Object.assign({eid: this.pc_eid}, saveData);\n        let scriptLocation = this.scriptLocation + \"?action=save_session_participant\";\n\n        window.top.restoreSession();\n        return window.fetch(scriptLocation,\n            {\n                method: 'POST'\n                ,headers: {\n                    'Content-Type': 'application/json'\n                }\n                ,body: JSON.stringify(postData)\n                ,redirect: 'manual'\n            })\n            .then(result => {\n                if (result.status == 400 || (result.ok && result.status == 200)) {\n                    return result.json();\n                } else {\n                    throw new Error(\"Failed to save participant in \" + this.pc_eid + \" with save data\");\n                }\n            })\n            .then(jsonResult => {\n                if (jsonResult.error) {\n                    this.handleSaveParticipantErrorResponse(jsonResult);\n                    return;\n                }\n\n                let callerSettings = jsonResult.callerSettings || {};\n                this.showActionAlert('success', this.__translations.PATIENT_INVITATION_SUCCESS);\n                // let's show we were successful and close things up.\n                this.__updatedCallerSettings = callerSettings;\n                let participants = (callerSettings.participantList || []).filter(pl => pl.role != 'provider');\n                this.__participantList = participants;\n                this.__updateParticipants = true;\n                this.updateParticipantControls();\n                this.showPrimaryScreen();\n                setTimeout(() => {\n                    this.closeDialogAndSendCallerSettings();\n                }, 1000);\n            })\n    }\n\n    closeDialogAndSendCallerSettings() {\n        jQuery(this.container).on(\"hidden.bs.modal\", () => {\n            try {\n                jQuery(this.container).off(\"hidden.bs.modal\");\n                this.closeCallback(this.__updatedCallerSettings);\n            }\n            catch (error)\n            {\n                console.error(error);\n            }\n            try {\n                // make sure we destruct even if the callback fails\n                this.destruct();\n            }\n            catch (error) {\n                this.destruct();\n            }\n        });\n        this.modal.hide();\n    }\n\n    sendSearchResults(inputValues) {\n        // example FHIR request\n        // let url = '/apis/default/fhir/Patient/_search?given:contains=<fname>&family:contains=<lname>&birthDate=<dob>'\n        let url = this.fhirLocation + '/Patient';\n        let searchParams = [];\n\n        if (inputValues.pid) {\n            searchParams.push(\"identifier=\" + encodeURIComponent(inputValues.pid));\n        }\n        if (inputValues.fname || inputValues.lname) {\n            let values = [];\n            if (inputValues.fname) {\n                values.push(encodeURIComponent(inputValues.fname));\n            }\n            if (inputValues.lname) {\n                values.push(encodeURIComponent(inputValues.lname));\n            }\n            searchParams.push(\"name:contains=\" + values.join(\",\"));\n        }\n\n        if (inputValues.DOB) {\n            // birthdate needs to be in Y-m-d prefix\n            searchParams.push(\"birthdate=\" + encodeURIComponent(inputValues.DOB));\n        }\n\n        if (inputValues.email) {\n            searchParams.push(\"email:contains=\" + encodeURIComponent(inputValues.email));\n        }\n\n        if (!searchParams.length) {\n            alert(this.__translations.SEARCH_REQUIRES_INPUT);\n            throw new Error(\"Failed to perform search due to missing search operator\");\n        }\n\n        url += \"?\" + searchParams.join(\"&\");\n        window.top.restoreSession();\n        let headers = {\n            'apicsrftoken': this.__apiCSRFToken\n        };\n        return window.fetch(url,\n            {\n                method: 'GET'\n                ,redirect: 'manual'\n                ,headers: headers\n            })\n            .then(result => {\n                if (!(result.ok && result.status == 200))\n                {\n                    this.showActionAlert('danger', this.__translations.OPERATION_FAILED);\n                    throw new Error(\"Failed to save participant in \" + this.pc_eid + \" with save data\");\n                } else {\n                    return result.json();\n                }\n            })\n            .then(result => {\n                if (result && result.hasOwnProperty('total') && result.total <= 0) {\n                    this.showActionAlert('info', this.__translations.SEARCH_RESULTS_NOT_FOUND);\n                    return [];\n                } else {\n                    this.clearActionAlerts();\n                    // return the array of result entries.\n                    return result.entry;\n                }\n            })\n    }\n\n    showPrimaryScreen() {\n        let screens = this.container.querySelectorAll('.screen') || [];\n        screens.forEach(i => {\n            if (i.classList.contains('primary-screen')) {\n                i.classList.remove('d-none');\n            } else {\n                i.classList.add('d-none');\n            }\n        });\n        this.__currentScreen = 'primary-screen';\n        this.updateParticipantControls();\n    }\n\n    updateParticipantControls() {\n\n        // let's update if our pid is different\n        if (this.__participantList.length <= 0) {\n            this.container.querySelector('.no-third-party-patient-row').classList.remove('d-none');\n            this.container.querySelectorAll('.third-party-patient-row').forEach(n => n.classList.add('d-none'));\n            return;\n        }\n        this.container.querySelector('.no-third-party-patient-row').classList.add('d-none');\n\n        this.container.querySelectorAll('.third-party-patient-row').forEach(n => n.classList.remove('d-none'));\n\n        if (this.__updateParticipants) {\n            let participantContainers = this.container.querySelectorAll('.patient-participant');\n            if (!participantContainers.length) {\n                console.error(\"Failed to find dom node with selector .patient-participant\");\n                return;\n            }\n            let templateNode = null;\n            participantContainers.forEach(pc => {\n                if (!pc.classList.contains('template')) {\n                    pc.remove();\n                } else {\n                    templateNode = pc;\n                }\n            });\n            if (!templateNode) {\n                console.error(\"Failed to find dom node with selector .patient-participant.template\");\n                return;\n            }\n            // now we clone for each participant we have\n            if (this.__participantList.length) {\n                this.__participantList.forEach(p => {\n                    let clonedNode = templateNode.cloneNode(true);\n                    // note setting the innerText on these nodes already handles the escaping\n                    this.setNodeInnerText(clonedNode, '.patient-name', p.callerName);\n                    this.setNodeInnerText(clonedNode, '.patient-email', p.email);\n                    clonedNode.classList.remove('template');\n                    clonedNode.classList.remove('d-none');\n\n                    let invitation = p.invitation || {};\n                    let btnInvitationCopy = clonedNode.querySelector('.btn-invitation-copy');\n                    let btnLinkCopy = clonedNode.querySelector('.btn-link-copy');\n                    let btnGenerateLink = clonedNode.querySelector('.btn-generate-link');\n\n                    if (invitation) {\n                        if (btnGenerateLink) {\n                            // setup our link generation process since the user has enabled the onetime\n                            // note the server will check the onetime setting and reject requests if its not enabled\n                            btnGenerateLink.addEventListener('click', this.generatePatientLink.bind(this, p.id));\n                        }\n                        btnInvitationCopy.addEventListener('click', this.copyPatientInvitationToClipboard.bind(this));\n                        btnLinkCopy.addEventListener('click', this.copyPatientLinkToClipboard.bind(this));\n                        btnLinkCopy.dataset['inviteId'] = p.id;\n\n                        if (invitation.generated) {\n                            // show our buttons, we lave the generate link button open again in case they need to generate a new link.\n                            btnLinkCopy.classList.remove('d-none');\n                            btnInvitationCopy.classList.remove('d-none');\n                        }\n\n                        // invitation text is escaped from innerText\n                        this.setNodeInnerText(clonedNode, '.patient-invitation-text', invitation.text || \"\")\n                    } else {\n                        console.error(\"Failed to find invitation data for patient \", p);\n                        btnInvitationCopy.classList.add('d-none');\n                        btnLinkCopy.classList.add('d-none');\n                    }\n\n                    templateNode.parentNode.appendChild(clonedNode);\n                });\n            }\n            this.__updateParticipants = false;\n        }\n    }\n\n    showNewPatientScreen() {\n        this.showSecondaryScreen('create-patient');\n    }\n\n    showSearchPatientScreen() {\n        this.showSecondaryScreen('search-patient');\n    }\n\n    showSecondaryScreen(screenName) {\n        let selector = '.' + screenName;\n        let primaryScreen = this.container.querySelector('.primary-screen');\n        if (!primaryScreen) {\n            console.error(\"Failed to find primary-screen selector for add-patient-dialog container\");\n            return;\n        }\n\n        primaryScreen.classList.add('d-none');\n\n        let screen = this.container.querySelector(selector);\n        if (screen) {\n            screen.classList.remove('d-none');\n        } else {\n            console.error(\"Failed to find selector for add-patient-dialog container \" + selector);\n        }\n        this.__currentScreen = screenName;\n    }\n\n\n    getInputValues(screen, inputs) {\n        let inputValues = {};\n        inputs.forEach((i) => {\n            let node = this.container.querySelector(\".\" + screen + ' input[name=\"' + i + '\"]');\n            if (node) {\n                inputValues[i] = node.value;\n            } else {\n                console.error(\"Failed to find input node with name \" + i);\n                inputValues[i] = null;\n            }\n        });\n        return inputValues;\n    }\n\n    inviteSearchResultPatient(pid) {\n        // hide the search results\n        this.displaySearchList(false);\n        this.showActionAlert('info', this.__translations.PATIENT_INVITATION_PROCESSING);\n        this.sendSaveParticipant({pid: pid})\n        .catch(error => {\n            console.error(error);\n            this.showActionAlert('danger', this.__translations.OPERATION_FAILED);\n            // show the search results\n            this.displaySearchList(true);\n        })\n    }\n\n    displaySearchList(shouldDisplay) {\n        let selector = \".search-patient .search-patient-list\";\n        let patientList = this.container.querySelector(selector);\n        if (!patientList) {\n            console.error(\"Failed to find \",selector);\n            return;\n        }\n        if (shouldDisplay) {\n            patientList.classList.remove('d-none');\n        } else {\n            patientList.classList.add('d-none');\n        }\n    }\n\n    populateSearchResults(result) {\n        console.log(\"populatingSearchResults with result \", result);\n        let selector = \".search-patient .search-patient-list\";\n        let patientList = this.container.querySelector(selector);\n        if (!patientList) {\n            console.error(\"Failed to find \",selector);\n            return;\n        }\n\n        patientList.classList.remove('d-none');\n        let row = patientList.querySelector('.duplicate-match-row-template');\n\n        // clear out the table rows\n        let parentNode = row.parentNode;\n        parentNode.replaceChildren();\n        parentNode.appendChild(row);\n\n        // need to loop on the result and populate per row\n        result.forEach(r => {\n            let resource = r.resource;\n            let clonedNode = row.cloneNode(true);\n            clonedNode.classList.remove('duplicate-match-row-template');\n            parentNode.appendChild(clonedNode);\n\n            let pid = (resource.identifier || []).find(i => i.type.coding.find(cd => cd.code == \"PT\") !== undefined);\n            let pidValue = pid.value || \"\";\n            this.setNodeInnerText(clonedNode, '.pid', pidValue);\n\n            let birthDate = resource.birthDate;\n            if (birthDate) {\n                this.setNodeInnerText(clonedNode, '.dob', birthDate);\n            }\n\n            let name = (resource.name || []).find(n => n.use == 'official');\n            if (name) {\n                this.setNodeInnerText(clonedNode, '.fname', name.given.join(\" \"));\n                this.setNodeInnerText(clonedNode, '.lname', name.family);\n            }\n\n            let email = (resource.telecom || []).find(t => t.system == 'email');\n            if (email) {\n                this.setNodeInnerText(clonedNode, '.email', email.value);\n            } else {\n                clonedNode.classList.add('missing-email');\n            }\n\n            if (pidValue) {\n                clonedNode.querySelector('.btn-select-patient').addEventListener('click', () => {\n                    this.inviteSearchResultPatient(pidValue);\n                });\n            }\n            clonedNode.classList.remove('d-none');\n        });\n    }\n\n    setNodeInnerText(node, selector, value) {\n        let subNode = node.querySelector(selector);\n        if (!subNode) {\n            console.error(\"Failed to find node with selector \" + selector);\n            return;\n        }\n        subNode.textContent = value;\n    }\n\n    searchParticipantsAction()\n    {\n        let inputs = ['fname', 'lname', 'DOB', 'email', 'pid'];\n        let inputValues = this.getInputValues('search-patient', inputs);\n        // form validation happens server side.\n        this.toggleActionButton(false);\n        this.sendSearchResults(inputValues)\n            .then(result => {\n                this.toggleActionButton(true);\n                if (result.length) {\n                    this.populateSearchResults(result);\n                }\n                else {\n                    this.populateSearchResults([]);\n                    let resultMessage = this.__translations.SEARCH_RESULTS_NOT_FOUND;\n                }\n            })\n            .catch(error => {\n                this.toggleActionButton(true);\n                console.error(error);\n            });\n    }\n\n    createPatientAction() {\n        let inputs = ['fname', 'lname', 'DOB', 'email'];\n        let inputValues = this.getInputValues('create-patient', inputs);\n        // for now we don't do the searching but we will do the invitation here...\n        this.clearActionAlerts();\n        this.showActionAlert('info', this.__translations.PATIENT_INVITATION_PROCESSING);\n        this.toggleActionButton(false);\n        this.sendSaveParticipant(inputValues)\n        .then(() => {\n            this.toggleActionButton(true);\n        })\n        .catch(error => {\n            this.toggleActionButton(true);\n            console.error(error);\n            this.showActionAlert('danger', this.__translations.OPERATION_FAILED);\n        });\n    }\n\n    toggleActionButton(enabled) {\n        let btns = this.container.querySelectorAll('.btn-create-patient,.btn-invite-search');\n        btns.forEach(b => b.disabled = !enabled);\n    }\n\n    handleSaveParticipantErrorResponse(json) {\n        // need to display the error message.\n        let message = [];\n        if (json.fields) {\n            if (json.fields.DOB) {\n                message.push(this.__translations.PATIENT_CREATE_INVALID_DOB);\n            }\n            if (json.fields.email) {\n                message.push(this.__translations.PATIENT_CREATE_INVALID_EMAIL);\n            }\n            if (json.fields.fname || json.fields.lname) {\n                message.push(this.__translations.PATIENT_CREATE_INVALID_NAME);\n            }\n            this.showActionAlert('danger', message.join(\". \"));\n        } else {\n            this.showActionAlert('danger', this.__translations.OPERATION_FAILED);\n        }\n    }\n\n    clearActionAlerts() {\n        let alerts = this.container.querySelectorAll('.alert');\n        alerts.forEach(a => {\n            if (a.classList.contains('alert-template')) {\n                a.classList.add('d-none');\n            } else {\n                a.parentNode.removeChild(a);\n            }\n        });\n    }\n\n    showActionAlert(type, message) {\n        this.clearActionAlerts(); // for now we will just remove these, we could animate & stack if we wanted.\n        let template = this.container.querySelector('.alert.alert-template');\n        let alert = template.cloneNode(true);\n        alert.innerText = message;\n        alert.classList.remove('alert-template');\n        alert.classList.remove('d-none');\n        alert.classList.add('alert-' + type);\n        template.parentNode.insertBefore(alert, template);\n        alert.scrollIntoView();\n    }\n\n    setupModal() {\n        // see templates/comlink/conference-room.twig\n        let id = 'telehealth-container-invite-patient';\n        // let bootstrapModalTemplate = window.document.createElement('div');\n        // we use min-height 90vh until we get the bootstrap full screen modal in bootstrap 5\n        let node = document.getElementById(id);\n        // we are going to clone the node and add an index to this...\n        let clonedNode = node.cloneNode(true);\n        clonedNode.id = id + \"-\" + this.__idx++;\n        node.parentNode.appendChild(clonedNode);\n        this.container = clonedNode;\n\n        this.modal = new bootstrap.Modal(this.container, {keyboard: false, focus: true, backdrop: 'static'});\n\n        this.addActionToButton('.btn-telehealth-confirm-cancel', this.cancelDialog.bind(this));\n        this.addActionToButton('.btn-show-new-patient-screen', this.showNewPatientScreen.bind(this));\n        this.addActionToButton('.btn-show-search-patient-screen', this.showSearchPatientScreen.bind(this));\n        this.addActionToButton('.btn-cancel-screen-action', this.showPrimaryScreen.bind(this));\n        this.addActionToButton('.btn-create-patient', this.createPatientAction.bind(this));\n        this.addActionToButton('.btn-invite-search', this.searchParticipantsAction.bind(this));\n\n        // we update the participant list as it may have changed from when the DOM originally sent it down.\n        this.__updateParticipants = true;\n        this.updateParticipantControls();\n    }\n\n    copyPatientLinkToClipboard(evt) {\n        let target = evt.currentTarget;\n        if (!target) {\n            console.error(\"Failed to get a dom node cannot proceed with copy\");\n            return;\n        }\n\n        let id = target.dataset['inviteId'];\n        if (!id) {\n            // no link just ignoring\n            console.error(\"Failed to find patient id to copy link for patient\");\n            this.showActionAlert('danger', this.__translations.CLIPBOARD_COPY_FAILURE);\n            return;\n        }\n        let participant = this.__participantList.find(pl => pl.id == id);\n        if (participant) {\n            let invitation = participant.invitation || {};\n            this.copyTextToClipboard(invitation.link || \"\");\n        } else {\n            this.showActionAlert('danger', this.__translations.CLIPBOARD_COPY_FAILURE);\n        }\n    }\n\n    sendGeneratePatientLink(patientId) {\n        let postData = {pc_eid: this.pc_eid, pid: patientId};\n        let scriptLocation = this.scriptLocation + \"?action=generate_participant_link\";\n\n        window.top.restoreSession();\n        return window.fetch(scriptLocation,\n            {\n                method: 'POST'\n                ,headers: {\n                    'Content-Type': 'application/json'\n                }\n                ,body: JSON.stringify(postData)\n                ,redirect: 'manual'\n            })\n            .then(result => {\n                if (result.status == 400 || result.status == 401 || (result.ok && result.status == 200)) {\n                    return result.json();\n                } else {\n                    throw new Error(\"Failed to generate participant link for participant \" + this.pid\n                        + \" with save data for session \" + this.pc_eid);\n                }\n            });\n    }\n\n    generatePatientLink(patientId, evt) {\n        // let's do a post to generate the link to OpenEMR\n        let target = evt.currentTarget;\n\n        // once we have the link we will update the button to copy the link.\n        // we will also insert the invitation text into the patient invitation text div.\n        // then we will show the copy button and the copy invitation button.\n        this.clearActionAlerts();\n        this.showActionAlert('info', this.__translations.PATIENT_INVITATION_PROCESSING);\n        this.toggleActionButton(false);\n        this.sendGeneratePatientLink(patientId)\n            .then(result => {\n                this.toggleActionButton(true);\n                this.clearActionAlerts();\n                if (result.success) {\n                    let invitation = result.invitation;\n                    let patient = this.__participantList.find(p => p.id == patientId);\n                    if (patient) {\n                        patient.invitation = invitation;\n                        this.__updateParticipants = true;\n                        this.updateParticipantControls();\n                        this.showActionAlert('success', this.__translations.PATIENT_INVITATION_GENERATED);\n                    } else {\n                        this.showActionAlert('danger', this.__translations.PATIENT_INVITATION_FAILURE);\n                    }\n                } else {\n                    this.showActionAlert('danger', this.__translations.PATIENT_INVITATION_FAILURE);\n                }\n            })\n            .catch(error => {\n                console.error(error);\n                this.showActionAlert('danger', this.__translations.PATIENT_INVITATION_FAILURE);\n            });\n    }\n\n    copyPatientInvitationToClipboard(evt) {\n        let target = evt.target;\n        if (!target) {\n            console.error(\"Failed to get a dom node cannot proceed with copy\");\n            return;\n        }\n\n        let closest = target.closest(\".patient-participant[data-pid]\");\n        if (!closest) {\n            this.showActionAlert('danger', this.__translations.CLIPBOARD_COPY_FAILURE);\n            throw new Error(\"Failed to find patient to copy invitation\");\n        }\n        let invitation = closest.querySelector(\".patient-invitation-text\");\n        if (!invitation) {\n            this.showActionAlert('danger', this.__translations.CLIPBOARD_COPY_FAILURE);\n            throw new Error(\"Failed to find invitation text with selector .patient-invitation-text\");\n        }\n        let text = invitation.textContent;\n        this.copyTextToClipboard(text);\n    }\n\n    copyTextToClipboard(text) {\n\n        // this is getting deprecated\n        if (navigator.clipboard && navigator.clipboard.writeText) {\n            navigator.clipboard.writeText(text).then(() => {\n                this.showActionAlert('success', this.__translations.CLIPBOARD_COPY_SUCCESS);\n            })\n                .catch(error => {\n                    console.error(error);\n                    this.showActionAlert('danger', this.__translations.CLIPBOARD_COPY_FAILURE);\n                })\n        } else {\n            console.error(\"clipboard.writeText does not exist\");\n            this.showActionAlert('danger', this.__translations.CLIPBOARD_COPY_FAILURE);\n        }\n    }\n\n    addActionToButton(selector, action) {\n        let btns = this.container.querySelectorAll(selector);\n        for (var i = 0; i < btns.length; i++)\n        {\n            btns[i].addEventListener('click', action);\n        }\n    }\n\n    show() {\n        if (!this.modal) {\n            this.setupModal();\n        }\n\n        this.modal.show();\n    }\n\n    destruct() {\n        this.modal = null;\n        // we clean everything up by removing the node which also removes the event listeners.\n        this.container.parentNode.removeChild(this.container);\n        this.container = null;\n    }\n}\n\n\n//# sourceURL=webpack://comlink-telehealth-js/./src/add-patient-dialog.js?");

/***/ }),

/***/ "./src/at-slot.js":
/*!************************!*\
  !*** ./src/at-slot.js ***!
  \************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"ATSlot\": function() { return /* binding */ ATSlot; }\n/* harmony export */ });\n/**\n * Represents a single video stream slot in the DOM.  This can be a shared screen, or camera screen in the telehealth\n * session.\n *\n * @package openemr\n * @link      http://www.open-emr.org\n * @author    Stephen Nielson <snielson@discoverandchange.com>\n * @copyright Copyright (c) 2023 Comlink Inc <https://comlinkinc.com/>\n * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3\n */\nclass ATSlot {\n\n    /**\n     *\n     * @type CallerSlot\n     * @private\n     */\n    __call = null;\n\n    /**\n     *\n     * @type HTMLElement\n     * @private\n     */\n    __container = null;\n\n    /**\n     *\n     * @type HTMLMediaElement\n     * @private\n     */\n    __video = null;\n\n    constructor(videoId) {\n        this.__call = null;\n        this.__container = document.getElementById(videoId);\n        this.__video = this.__container.querySelector('.participant-video');\n        if (!this.__video)\n        {\n            throw new Error(\"Failed to find #\" + videoId + \" element\");\n        }\n    }\n\n\n    hasVideo() {\n        return !this.isAvailable();\n    }\n\n    getVideoStream() {\n        return this.__video.srcObject;\n    }\n\n    isAvailable() {\n        return this.__call == null;\n    }\n\n    getRemotePartyId() {\n        if (this.__call) {\n            return this.__call.getRemotePartyId();\n        }\n        return null;\n    }\n\n\n    attach(call, stream, displayTitle) {\n        this.__call = call;\n        if (call == null || stream == null)\n        {\n            console.error(\"Call or stream were null.  Cannot proceed\", {call: call, stream: stream});\n            throw new Error(\"call and stream cannot be null\");\n        }\n        // this.__call.setUserData(this);\n        this.__video.srcObject = stream;\n        this.__video.play();\n        // for now we will just have the hover title be the display title for now.\n        // eventually we could have this be a full DOM Node that is always displayed.\n        let label = this.__container.querySelector('.participant-label');\n        if (label) {\n            label.textContent = jsText(displayTitle);\n        }\n\n        this.__video.title = jsText(displayTitle);\n    }\n\n    detach() {\n        if (this.__call) {\n            this.__call.setUserData(null);\n        }\n        this.__call = null;\n        this.__video.srcObject = null;\n    }\n\n    hide() {\n        if (this.__container) {\n            this.__container.classList.add('d-none');\n        }\n    }\n    show() {\n        if (this.__container) {\n            this.__container.classList.remove('d-none');\n        }\n    }\n\n    setPinnedStatus(status) {\n        if (this.__container) {\n            if (status) {\n                this.__container.classList.add('pinned');\n            } else {\n                this.__container.classList.remove('pinned');\n            }\n        }\n    }\n}\n\n//# sourceURL=webpack://comlink-telehealth-js/./src/at-slot.js?");

/***/ }),

/***/ "./src/caller-slot.js":
/*!****************************!*\
  !*** ./src/caller-slot.js ***!
  \****************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"CallerSlot\": function() { return /* binding */ CallerSlot; }\n/* harmony export */ });\n/* harmony import */ var _at_slot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./at-slot.js */ \"./src/at-slot.js\");\n/**\n * Represents a unique participant caller in the telehealth conference room.  It can have multiple video slots\n * in the call (for screen share and camera feeds).\n *\n * @package openemr\n * @link      http://www.open-emr.org\n * @author    Stephen Nielson <snielson@discoverandchange.com>\n * @copyright Copyright (c) 2023 Comlink Inc <https://comlinkinc.com/>\n * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3\n */\n\n\n\nclass CallerSlot {\n\n    /**\n     *\n     * @type HTMLMediaElement\n     * @private\n     */\n    __videoNode = null;\n\n    /**\n     *\n     * @type HTMLVideoElement\n     * @private\n     */\n    __screenshareNode = null;\n\n    /**\n     * @type ATSlot\n     * @private\n     */\n    __videoSlot = null;\n\n    /**\n     *\n     * @type ATSlot\n     * @private\n     */\n    __screenshareSlot = null;\n\n    /**\n     *\n     * @type ATSlot\n     * @private\n     */\n    __currentSlot = null;\n\n    __containerId = null;\n\n    __boundInternalEvent = null;\n\n    /**\n     * The participant data object\n     * @private\n     */\n    __participant = null;\n\n    /**\n     * Returns whether this caller slot has been pinned to always show on the presentation screen\n     * @type {boolean}\n     * @private\n     */\n    __isPinned = false;\n\n    /**\n     *\n     * @type {Array}\n     * @private\n     */\n    __selectCallbacks = [];\n\n    constructor(containerId, index) {\n        let domNode = document.getElementById(containerId);\n        let templateClassName = 'participant-list-template-node';\n        let templateNode = domNode.querySelector('.' + templateClassName);\n\n        if (!domNode) {\n            throw new Error(\"Failed to find container id with \" + containerId);\n        }\n        if (!templateNode) {\n            throw new Error(\"Failed to find template container with .\" + templateClassName);\n        }\n        let videoId = 'participant-video-' + index;\n        let screenshareId = 'participant-screenshare-' + index;\n        this.__boundInternalEvent = this.handleSelectEvent.bind(this);\n        this.__videoNode = this.__setupParticipantContainer(containerId, videoId, this.__boundInternalEvent);\n        this.__screenshareNode = this.__setupParticipantContainer(containerId, screenshareId, this.__boundInternalEvent);\n        this.__videoSlot = new _at_slot_js__WEBPACK_IMPORTED_MODULE_0__.ATSlot(videoId);\n        this.__screenshareSlot = new _at_slot_js__WEBPACK_IMPORTED_MODULE_0__.ATSlot(screenshareId);\n        this.__currentSlot = this.__videoSlot;\n        this.__selectCallbacks = [];\n        this.__isPinned = false;\n    }\n\n    __setupParticipantContainer(containerId, id, clickEvent) {\n        // should all of this be moved to ATSlot?\n\n        let domNode = document.getElementById(containerId);\n        let templateClassName = 'participant-list-template-node';\n        let templateNode = domNode.querySelector('.' + templateClassName);\n\n        if (!domNode) {\n            throw new Error(\"Failed to find container id with \" + containerId);\n        }\n        if (!templateNode) {\n            throw new Error(\"Failed to find template container with .\" + templateClassName);\n        }\n        let participantNode = templateNode.cloneNode(true);\n        participantNode.classList.remove(templateClassName);\n        participantNode.id = id;\n        domNode.appendChild(participantNode);\n        participantNode.addEventListener('click', clickEvent);\n        return participantNode;\n    }\n\n    setPinnedStatus(status) {\n        this.__isPinned = status;\n        if (this.__videoSlot) {\n            this.__videoSlot.setPinnedStatus(status);\n        }\n        if (this.__screenshareSlot) {\n            this.__screenshareSlot.setPinnedStatus(status);\n        }\n    }\n\n    isPinned() {\n        return this.__isPinned;\n    }\n\n    handleSelectEvent(evt) {\n        this.__selectCallbacks.forEach(cb => cb(this));\n    }\n\n    addCallerSelectListener(callback) {\n        this.__selectCallbacks.push(callback);\n    }\n\n    getRemotePartyId() {\n        if (this.__currentSlot) {\n            return this.__currentSlot.getRemotePartyId();\n        }\n        return null;\n    }\n\n    hide() {\n        if (this.__currentSlot) {\n            this.__currentSlot.hide();\n        }\n    }\n    show() {\n        if (this.__currentSlot) {\n            this.__currentSlot.show();\n        }\n    }\n\n    isAvailable() {\n        return this.__videoSlot.isAvailable();\n    }\n\n    isAvailableForCall(call) {\n        // we say things are available if the remote id is the same as the caller remote party id\n        // or if the video slot has no call\n        if (this.__videoSlot.isAvailable() || this.__videoSlot.getRemotePartyId() == call.getRemotePartyId())\n        {\n            return true;\n        }\n        return false;\n    }\n\n    getCurrentCallStream() {\n        if (this.__currentSlot ) {\n            return this.__currentSlot .getVideoStream();\n        }\n        return null;\n    }\n\n    getParticipant() {\n        return this.__participant;\n    }\n\n    attach(call, stream, participant) {\n        if (call == null || stream == null || participant == null)\n        {\n            console.error(\"Call, stream, or participant were null.  Cannot proceed\", {call: call, stream: stream\n                , participant: participant});\n            throw new Error(\"call, stream, and participant cannot be null\");\n        }\n\n        // let's us cleanup screensharing and video slots if we already have it allocated.\n        // this only happens if the same user calls into the call\n        if (call.isScreenSharing()) {\n            if (!this.__screenshareSlot.isAvailable()) {\n                this.__screenshareSlot.detach();\n            }\n            this.__screenshareSlot.attach(call, stream, participant.callerName || \"\");\n            this.showScreenshare();\n        } else {\n            if (!this.__videoSlot.isAvailable()) {\n                this.__videoSlot.detach();\n            }\n            this.__videoSlot.attach(call, stream, participant.callerName || \"\");\n            this.showVideo();\n        }\n        // set ourselves up as the user data\n        // TODO: @adunsulag I don't like how I setUserData here but clear it in the ATSlot object.\n        this.__participant = participant;\n        call.setUserData(this);\n    }\n\n    showScreenshare() {\n        this.__videoSlot.hide();\n        this.__screenshareSlot.show();\n        this.__currentSlot = this.__screenshareSlot;\n    }\n\n    showVideo() {\n        this.__videoSlot.show();\n        this.__screenshareSlot.hide();\n        this.__currentSlot = this.__videoSlot;\n    }\n\n    detachScreenshare() {\n        this.__screenshareSlot.detach();\n        if (this.__videoSlot) {\n            this.showVideo();\n        }\n    }\n\n    detatchVideo() {\n        this.__videoSlot.detach();\n        this.__currentSlot = null;\n        this.__participant = null;\n    }\n\n    detach() {\n        this.detachScreenshare();\n        this.detatchVideo();\n    }\n\n    destruct() {\n        // do we really need a detach at this point?  We might as well just remove all of the nodes...\n        this.detach();\n        this.__selectCallbacks = [];\n        if (this.__screenshareNode) {\n            this.__screenshareNode.removeEventListener('click', this.__boundInternalEvent);\n            this.__screenshareNode.parentNode.removeChild(this.__screenshareNode);\n            this.__screenshareNode = null;\n        }\n        if (this.__videoNode) {\n            this.__videoNode.removeEventListener('click', this.__boundInternalEvent);\n            this.__videoNode.parentNode.removeChild(this.__videoNode);\n            this.__videoNode = null;\n        }\n    }\n}\n\n//# sourceURL=webpack://comlink-telehealth-js/./src/caller-slot.js?");

/***/ }),

/***/ "./src/conference-room.js":
/*!********************************!*\
  !*** ./src/conference-room.js ***!
  \********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"ConferenceRoom\": function() { return /* binding */ ConferenceRoom; }\n/* harmony export */ });\n/* harmony import */ var _confirm_session_close_dialog_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./confirm-session-close-dialog.js */ \"./src/confirm-session-close-dialog.js\");\n/* harmony import */ var _configure_session_call_dialog_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./configure-session-call-dialog.js */ \"./src/configure-session-call-dialog.js\");\n/* harmony import */ var _video_bar_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./video-bar.js */ \"./src/video-bar.js\");\n/* harmony import */ var _caller_slot_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./caller-slot.js */ \"./src/caller-slot.js\");\n/* harmony import */ var _telehealth_bridge_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./telehealth-bridge.js */ \"./src/telehealth-bridge.js\");\n/* harmony import */ var _presentation_screen__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./presentation-screen */ \"./src/presentation-screen.js\");\n/* harmony import */ var _cvb_min_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./cvb.min.js */ \"./src/cvb.min.js\");\n/* harmony import */ var _add_patient_dialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./add-patient-dialog */ \"./src/add-patient-dialog.js\");\n/* harmony import */ var _minimized_conference_room__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./minimized-conference-room */ \"./src/minimized-conference-room.js\");\n/* harmony import */ var _local_caller_slot__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./local-caller-slot */ \"./src/local-caller-slot.js\");\n/**\n * Javascript Controller for the entire conference room.  It handles both the waiting room and session conference room\n * controls and interactions.\n *\n * @package openemr\n * @link      http://www.open-emr.org\n * @author    Stephen Nielson <snielson@discoverandchange.com>\n * @copyright Copyright (c) 2023 Comlink Inc <https://comlinkinc.com/>\n * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3\n */\n\n\n\n\n\n\n\n\n\n\n\n\n// TODO: @adunsulag convert this to class nomenclature (big project for future)\nfunction ConferenceRoom(apiCSRFToken, enabledFeatures, translations, scriptLocation)\n{\n    let conf = this;\n\n    this.apiCSRFToken = apiCSRFToken;\n    this.waitingRoomTemplate = null;\n    this.conferenceRoomTemplate = null;\n    this.callerSettings = null;\n    this.features = enabledFeatures; // the features that are enabled from the server.\n    this.telehealthSessionData = null;\n    this.videoBar = null;\n    this.ROOM_TYPE_WAITING = 'waiting';\n    this.ROOM_TYPE_CONFERENCE = 'conference';\n\n    // decibel threshold that determines that there is audio activity detected by a remote party\n    this.dbThresholdSetting = -45;\n\n    this.buttonSettings = {\n        microphoneEnabled: true\n        ,cameraEnabled: true\n        ,screensharingEnabled: false\n    };\n\n    /**\n     * The container node of the room\n     * @type {HTMLElement}\n     */\n    this.roomNode = null;\n\n    /**\n     * Milliseconds to update the session information\n     * @type {number}\n     */\n    this.sessionUpdatePollingTime = 5000;\n\n    /**\n     * Milliseconds to check if we should hide the conference room session controls or not\n     * @type {number}\n     */\n    this.sessionControlsActiveTime = 500;\n\n    /**\n     * Milliseconds that a session is determined to be idle (so controls and other stuff can be hidden)\n     * @type {number}\n     */\n    this.sessionControlsIdleTime = 5000;\n\n    /**\n     * The date timestamp that the local user was active from a visual control perspective (mouse move, click presentation screen, etc)\n     * @type {Date|null}\n     */\n    this.lastActiveDate = null;\n\n    /**\n     * What type of room this conference room is\n     * @see ROOM_TYPE_WAITING\n     * @see ROOM_TYPE_CONFERENCE\n     * @type string\n     */\n    this.room = null;\n\n    /**\n     * DOM Node for the modal that is popped up on the screen holding the waiting room / conference room modal\n     * @type HTMLElement\n     */\n    this.roomModal = null;\n\n    /**\n     * Are we currently in the conference room session\n     * @type {boolean}\n     */\n    this.inSession = false;\n\n    /**\n     * The minimized conference room handler\n     * @type {MinimizedConferenceRoom}\n     * @private\n     */\n    this.__minimizedConferenceRoom = null;\n\n    /**\n     * Tracking interval for the conference room session polling\n     * @type {number}\n     */\n    this.sessionUpdateInterval = null;\n\n    /**\n     * Tracking interval for the conference room user activity polling\n     * @type {number}\n     */\n    this.sessionControlsActiveInterval = null;\n\n    this.__hasLocalPermisions = false;\n    /** @private */\n    this.__bridge = null;\n\n    /**\n     *\n     * @type LocalCallerSlot\n     * @private\n     */\n    this.__localCallSlot = null;\n\n    /**\n     * @type CallerSlot[]\n     * @private\n     * */\n    this.__slots = [];\n\n    /**\n     *\n     * @type CallerSlot\n     * @private\n     */\n    this.__localCaller = null;\n\n    /**\n     *\n     * @type CallerSlot\n     * @private\n     */\n    this.__remoteCaller = null;\n\n    this.__remoteCallSlot = null;\n\n    this.__isShutdown = true;\n\n    this.__callerIdx = 0;\n\n    // let's allow for our max slots for now\n    this.__maxSlots = 3;\n\n    /**\n     *\n     * @type PresentationScreen\n     * @private\n     */\n    this.__presentationScreen = null;\n\n    /**\n     *\n     * @type string\n     * @private\n     */\n    this.__focusCallerUuid = null;\n\n    /**\n     *\n     * @type string\n     * @private\n     */\n    this.__pinnedCallerUuid = null;\n\n\n    /**\n     * Is the conference room currently  minimized\n     * @type {boolean}\n     */\n    this.isMinimized = function() {\n        if (this.__minimizedConferenceRoom) {\n            return this.__minimizedConferenceRoom.isMinimized();\n        }\n        return false;\n    };\n\n\n    this.allocateSlot = function(call, stream) {\n        // as we can get multiple events we only want to allocate on the call if we don't have any stream data setup.\n        if (!call.getUserData()) {\n            // in the event of a network hiccup we go through and allocate the slot\n            let needNewSlot = true;\n            let slotsLength = this.__slots.length;\n            for (var i = 0; i < slotsLength; i++) {\n                if (this.__slots[i].isAvailableForCall(call)) {\n                    this.__slots[i].attach(call, stream, this.getParticipantForCall(call));\n                    needNewSlot = false;\n                    break;\n                }\n            }\n            if (needNewSlot && slotsLength <= this.__maxSlots) {\n                let newCaller = new _caller_slot_js__WEBPACK_IMPORTED_MODULE_3__.CallerSlot('participant-list-container', this.__callerIdx++);\n                newCaller.addCallerSelectListener(function(callerSlot) {\n                    conf.togglePinnedCallerId(callerSlot.getRemotePartyId());\n                    conf.updateParticipantDisplays();\n                });\n                this.__slots.push(newCaller);\n                slotsLength++;\n                newCaller.attach(call, stream, this.getParticipantForCall(call));\n            }\n            // now we need to update our focus caller and participant list if we have it\n            if (slotsLength == 1) {\n                // if we only have one person on the call they need to be the focus of the video\n                this.setCurrentCallerFocusId(call.getRemotePartyId());\n            }\n            this.updateParticipantDisplays();\n        }\n    };\n\n    this.updateParticipantDisplays = function() {\n        if (this.__isShutdown) {\n            // nothing to do in the loop so let's just exit\n            return;\n        }\n        // TODO: @adunsulag based on performance we may want an isDirty flag here so we don't update the display\n        // unless something has changed\n\n        // based on the mode of the conference room we will update the presentation screen and the participant list\n        let hasPresentationScreen = false;\n        // if we only have one other participant... or the screen is minimized we want to hide the local speaker.\n        let twoWayCall = this.__slots.length <= 1;\n        let isMinimized = this.isMinimized();\n        // we override the call with the pinned caller, then our currently speaking caller, finally we just have null\n        let presentationScreenRemotePartyId = this.__pinnedCallerUuid || this.__focusCallerUuid || null;\n        for (var i = 0; i < this.__slots.length; i++) {\n            if (this.__slots[i].getRemotePartyId() == presentationScreenRemotePartyId) {\n                hasPresentationScreen = true;\n                this.__presentationScreen.attach(this.__slots[i]);\n                if (twoWayCall && !isMinimized) {\n                    // hide the remote caller in a two way call in the participant list ONLY if we are not minimized\n                    // as they show up in the presentation screen.\n                    this.__slots[i].hide();\n                } else {\n                    this.__slots[i].show();\n                }\n                // this condition never executes for now as we don't keep a local CallerSlot\n                // if we do, we will leave this in for now\n            } else if (isMinimized && this.__slots[i].getRemotePartyId() == this.getLocalPartyId()) {\n                this.__slots[i].hide(); // hide the local caller from the participant list when we are minimized\n            } else {\n                // make sure we are showing everyone, including ourselves if we don't hide the local speaker\n                this.__slots[i].show();\n            }\n        }\n        // only hide if we are minimized\n        if (this.__localCallSlot) {\n            if (isMinimized) {\n                this.__localCallSlot.hide();\n            } else {\n                this.__localCallSlot.show();\n            }\n        }\n\n        // if we get here we are going to just detatch\n        if (!hasPresentationScreen) {\n            // check to see if our pinned slot is the local caller\n            if (this.__localCallSlot.getRemotePartyId() == presentationScreenRemotePartyId) {\n                this.__presentationScreen.attach(this.__localCallSlot);\n            } else {\n                this.__presentationScreen.detach();\n            }\n        }\n\n        if (!this.hasRemoteParticipants()) {\n            if (!this.__isShutdown) {\n                this.toggleRemoteVideo(false);\n            }\n        }\n\n        if (this.__slots.length) {\n            this.buttonSettings.screensharingEnabled = true;\n        } else {\n            this.buttonSettings.screensharingEnabled = false;\n        }\n        this.resetConferenceVideoBar();\n    };\n\n    this.isAuthorizedParticipant = function(callerId) {\n        let participantList = this.callerSettings.participantList || [];\n        let participant = participantList.find((p => p.uuid == callerId));\n        return participant !== undefined;\n    };\n\n    this.getRemoteParticipantList = function() {\n        let participantList = this.callerSettings.participantList || [];\n        return participantList.filter(p => p.uuid !== conf.callerSettings.callerUuid);\n    };\n\n    this.getLocalParticipant = function() {\n        return this.findParticipantForId(conf.callerSettings.callerUuid);\n    };\n\n    this.getParticipantForCall = function(call) {\n        return this.findParticipantForId(call.getRemotePartyId());\n    };\n\n    this.findParticipantForId = function(callerId) {\n        let participantList = this.callerSettings.participantList || [];\n        let participant = participantList.find((p => p.uuid == callerId));\n        return participant;\n    };\n\n    this.setParticipantInCallRoomStatus = function(callerId, status) {\n        if (this.__isShutdown) {\n            // if we are shut down no point in updating the call room status as we are just dealing\n            // with the after effects of callback triggers\n            return;\n        }\n        status = status == 'Y' ? 'Y' : 'N';\n        // if we have been destroyed and are still processing\n        let callerSettings = this.callerSettings || {};\n        let participantList = callerSettings.participantList || [];\n        let participant = participantList.find((p => p.uuid == callerId));\n        if (participant) {\n            participant.inRoom = status;\n        } else {\n            console.error(\"participant was not found in participant list for callerId \" + callerId);\n        }\n    };\n\n    this.getLocalPartyId = function() {\n        return conf.callerSettings.callerUuid;\n    };\n\n    /**\n     * Returns the caller slot with the caller id that is passed in.\n     * @param id\n     * @returns {CallerSlot|undefined}\n     */\n    this.findCallerSlotWithId = function(id) {\n        if (id == this.callerSettings.callerUuid) {\n            return this.__localCallSlot;\n        }\n\n        return this.__slots.find(s => s.getRemotePartyId() === id);\n    };\n\n    this.togglePinnedCallerId = function(uuid) {\n        if (this.__pinnedCallerUuid) {\n            // need to unset it if its the same\n            let callerSlot = this.findCallerSlotWithId(this.__pinnedCallerUuid);\n            // the slot may have been removed so ok if we don't find it.\n            if (callerSlot && callerSlot.isPinned()) {\n                callerSlot.setPinnedStatus(false);\n            }\n        }\n        if (uuid != this.__pinnedCallerUuid) {\n            let callerSlot = this.findCallerSlotWithId(uuid);\n            if (callerSlot) {\n                this.__pinnedCallerUuid = uuid;\n                callerSlot.setPinnedStatus(true);\n                this.setCurrentCallerFocusId(uuid);\n            } else {\n                console.error(\"Failed to find pinned caller slot with uuid \" + uuid);\n            }\n        } else {\n            this.__pinnedCallerUuid = null;\n        }\n\n    };\n\n    this.setCurrentCallerFocusId = function(uuid) {\n        this.__focusCallerUuid = uuid;\n    };\n\n    this.getCurrentCallerFocusId = function() {\n        // if we use audio monitoring we can switch, or if the user pins a speaker we can this this\n        // however, for now we focus on the callee for now\n        return this.__focusCallerUuid;\n    };\n\n    this.restartMediaStream = function() {\n        if (conf.__localCallSlot.hasMediaStream()) {\n            conf.__bridge.closeLocalMediaStream();\n        }\n\n        return conf.__bridge.getLocalMediaStream()\n            .then(stream => conf.handleLocalMediaStreamStarted(stream))\n            .catch(error => conf.handleLocalMediaStreamFailed(error));\n    };\n    this.handleLocalMediaStreamStarted = function(stream) {\n        conf.__localCallSlot.attach(stream);\n        conf.__hasLocalPermisions = true;\n        conf.toggleJoinButton(conf.shouldEnableJoinButton());\n        conf.togglePermissionBox(false);\n        return conf.__hasLocalPermisions;\n    };\n    this.handleLocalMediaStreamFailed = function(error) {\n        console.error(error);\n        conf.__hasLocalPermisions = false;\n        conf.toggleJoinButton(conf.shouldEnableJoinButton());\n        conf.togglePermissionBox(true);\n        return conf.__hasLocalPermisions;\n    };\n\n    this.startBridge = function() {\n        conf.__localCallSlot = new _local_caller_slot__WEBPACK_IMPORTED_MODULE_9__.LocalCallerSlot(document.getElementById('local-video-container'), this.getLocalParticipant());\n        // conf.__localCallSlot = document.getElementById('local-video');\n        conf.__localCallSlot.setMuted(true);\n        // conf.__localCallSlot.muted = true;\n\n        conf.__bridge = new _telehealth_bridge_js__WEBPACK_IMPORTED_MODULE_4__.TelehealthBridge(conf.callerSettings.callerUuid, conf.callerSettings.apiKey\n            , conf.callerSettings.serviceUrl);\n\n        let bridgeHandlers = {\n            onincomingcall: conf.handleIncomingCall.bind(conf)\n            ,onbridgeactive: (bridge) => {\n                conf.restartMediaStream();\n            }\n            ,onbridgeinactive: (bridge) => {\n                if (conf.__localCallSlot) {\n                    conf.__localCallSlot.stop();\n                    // conf.__localCallSlot.srcObject = null;\n                }\n            }\n            ,onbridgefailure: (bridge) => {\n                if (conf.__localCallSlot) {\n                    conf.__localCallSlot.stop();\n                }\n                alert(translations.BRIDGE_FAILED);\n            }\n        };\n\n        conf.__bridge.startBridge(bridgeHandlers);\n        conf.__isShutdown = false;\n    };\n    //\n    // conf.shutdown = function()\n    // {\n    //     if (conf.__isShutdown)\n    //     {\n    //         return;\n    //     }\n    //\n    //     conf.__bridge.shutdown();\n    //     conf.__localCallSlot.stop();\n    //     console.log(\"Shutting down \" +  conf.callerSettings.callerUuid)\n    //     conf.__isShutdown = true;\n    // };\n\n    this.setCallHandlers = function(call) {\n        // Callback: streams updated\n        //\n        call.oncallstarted = (call) => {\n            conf.handleCallStartedEvent(call);\n        };\n        // Once we have the remote stream we'll allocate a video slot.\n        call.onstreamupdated =\n            (call, stream) => {\n                console.log(\"onstreamupdated \" + conf.callerSettings.calleeUuid);\n                conf.allocateSlot(call, stream);\n            };\n\n        // Callback: call ended\n        //\n        // When the call ends we free the video slot.\n        call.oncallended = (call) => {\n            conf.handleCallEndedEvent(call);\n        };\n        // we don't have an audio stream when working with screen sharing.\n        if (!call.isScreenSharing()) {\n            call.attachActivityMonitor(conf.dbThresholdSetting, (call) => {\n                conf.handleActivityEvent(call);\n            });\n        }\n    };\n\n    /**\n     * Used to make a video call to the bridge\n     * @param calleeId\n     */\n    this.makeCall = function(calleeId) {\n        const call = conf.__bridge.createVideoCall(calleeId);\n\n        conf.setCallHandlers(call);\n\n        // Callback: outbound call rejected\n        //\n        // If the call is rejected we do nothing. We know that in that case the\n        // stream will not have been created and, consequently, we will not have\n        // created the video element.\n        call.oncallrejected = (call) => {\n            console.log(call);\n            console.log(\"oncallrejected \" + conf.callerSettings.calleeUuid);\n            // if the call is rejected the provider dropped off before we connected so we go back to the conference\n            // room\n            conf.handleCallEndedEvent(call);\n        };\n\n        // Finally, start the call\n        call.start().catch((e) => {\n            alert(translations.CALL_CONNECT_FAILED);\n            console.log(\"call exception \" + conf.callerSettings.calleeUuid);\n            console.error(e);\n            conf.handleCallEndedEvent(call);\n        });\n        return call;\n    };\n\n    this.makeScreenshareCall = function(callees) {\n        conf.__bridge.createScreenSharingCall(callees)\n            .catch(e => {\n                alert(translations.CALL_CONNECT_FAILED);\n                console.log(\"call exception \" + conf.callerSettings.calleeUuid);\n                console.error(e);\n            });\n    };\n\n    this.enableMicrophone = function(flag) {\n        conf.__bridge.enableMicrophone(flag);\n    };\n\n    this.enableCamera = function(flag) {\n        conf.__bridge.enableCamera(flag);\n    };\n\n    this.hasLocalPermissionsEnabled = function()\n    {\n        return conf.__hasLocalPermisions;\n    };\n\n\n    /**\n     * Checks to make sure that the user with the given calleeId is allowed to talk to the current conference room caller\n     * @param call The call that we are going to verify\n     * @returns {Promise<boolean>}\n     */\n    this.canReceiveCall = function(call)\n    {\n        let callerId = call.getRemotePartyId();\n        // we could double check again by hitting the server and verifying the session has started and accept\n        // the call, but that seems pretty paranoid to double check that...\n        if (this.isAuthorizedParticipant(callerId))\n        {\n            return Promise.resolve({call: call, canCall: true});\n        }\n        else\n        {\n            return Promise.resolve({call: call, canCall: false});\n        }\n    };\n\n    this.getRemoteScriptLocation = function()\n    {\n        return scriptLocation;\n    };\n\n    this.getTelehealthLaunchData = function(data)\n    {\n        var scriptLocation = this.getRemoteScriptLocation() + '?action=get_telehealth_launch_data&eid=' + encodeURIComponent(data.pc_eid);\n        window.top.restoreSession();\n        return window.fetch(scriptLocation, {redirect: \"manual\"});\n    };\n\n    this.setupProviderWaitingRoom = function()\n    {\n        let modal = this.createModalWithContent(conf.waitingRoomTemplate);\n        // // now we will attach all of our event listeners here onto the document content.\n        let container = document.getElementById('telehealth-container');\n        conf.initWaitingRoomEvents(container);\n        conf.roomModal = modal;\n        conf.roomModal.show();\n    };\n\n    this.setupWaitingRoom = function()\n    {\n        conf.setupProviderWaitingRoom();\n    };\n\n    this.handleIncomingCall = function(call)\n    {\n\n        // we will hit the server to verify that the caller can actually make this call\n        this.canReceiveCall(call)\n            .then((result) => {\n                if (!result.canCall) {\n                    console.log(\"Call from \" + result.call.getRemotePartyId() + \" not authorized by server for \"  + conf.callerSettings.callerUuid);\n                    result.call.reject();\n                    return;\n                }\n\n                conf.setCallHandlers(result.call);\n                result.call.accept();\n                console.log(\"Call accepted from \" + result.call.getRemotePartyId() + \" for \"  + conf.callerSettings.callerUuid);\n                // NOTE that result.call.accept does NOT fire the oncallstarted event for the call stream... so we have to\n                // toggle our remote video here instead.\n                conf.toggleRemoteVideo(true);\n\n                // mark the participant as being in the room\n                conf.setParticipantInCallRoomStatus(result.call.getRemotePartyId(), 'Y');\n            })\n            .catch(error => {\n                call.reject();\n            });\n    };\n\n    this.init = function(data)\n    {\n        if (!data.pc_eid)\n        {\n            alert(translations.SESSION_LAUNCH_FAILED);\n            return;\n        }\n\n        // add our vh resize calculator so we can make sure our viewpoint is constant.\n        conf.updateTelehealthFullVH(); // first set our values here\n        window.addEventListener('resize', conf.updateTelehealthFullVH);\n\n        conf.telehealthSessionData = data;\n        // we grab everything up front as anything dealing with video playback needs to be triggered by a button on iOS devices\n        // so we have to make sure we grab everything here.\n\n        // we could also make sure we create users when we update... that would resolve the issue as well.\n        let getLaunchData = conf.getTelehealthLaunchData(data);\n\n        getLaunchData\n            .then(function(result) {\n                if (!(result.ok && result.status == 200)) {\n                    throw new Error(\"Failed to fetch data\");\n                }\n\n                return result.json();\n            })\n            .then(launchData => {\n                conf.inSession = true;\n                conf.callerSettings = launchData.callerSettings;\n                conf.setCurrentCallerFocusId(launchData.callerSettings.calleeUuid);\n                conf.waitingRoomTemplate = launchData.waitingRoom;\n                conf.conferenceRoomTemplate = launchData.conferenceRoom;\n                conf.setupWaitingRoom();\n                conf.startBridge();\n                conf.room = conf.ROOM_TYPE_WAITING;\n            })\n            .catch(function(error) {\n                console.error(error);\n                // null out our values if we never started our session.\n                if (!conf.__bridge) {\n                    alert(translations.SESSION_LAUNCH_FAILED);\n                    conf.destruct(); // shut things down if we don't have a valid session.\n                }\n            });\n    };\n\n    this.cleanupSlots = function() {\n        this.__slots.forEach(s => {\n            try {\n                // don't let a slot cleanup stop everything\n                s.destruct();\n            } catch (error) {\n                console.error(\"Failed to cleanup slot \", error);\n            }\n        });\n        this.__slots = [];\n    };\n\n    this.destruct = function()\n    {\n        // shouldn't\n        if (this.__isShutdown) {\n            console.log(\"destruct called multiple times while application has already shutdown.  Ignoring\");\n            return;\n        }\n\n        conf.inSession = false;\n        conf.waitingRoomTemplate = null;\n        conf.conferenceRoomTemplate = null;\n        if (conf.videoBar) {\n            conf.videoBar.destruct();\n            conf.videoBar = null;\n        }\n        if (conf.room == conf.ROOM_TYPE_WAITING)\n        {\n            // TODO: do any cleanup needed here\n        }\n        else if (conf.room == conf.ROOM_TYPE_CONFERENCE)\n        {\n            // TODO: do any cleanup needed here.\n        }\n        if (conf.sessionUpdateInterval !== null)\n        {\n            clearInterval(conf.sessionUpdateInterval);\n            conf.sessionUpdateInterval = null;\n        }\n\n        if (conf.sessionControlsActiveInterval !== null) {\n            clearInterval(conf.sessionControlsActiveInterval);\n            conf.sessionControlsActiveInterval = null;\n        }\n        if (conf.roomNode) {\n            conf.cleanupParticipantActiveEvents();\n            conf.roomNode = null;\n        }\n        let container = document.getElementById('telehealth-container');\n\n        // cleanup any outstanding slots we have.\n        conf.cleanupSlots();\n\n        if (conf.__bridge && conf.__bridge.shutdown)\n        {\n            // catch any problems from the library so we can still clean up.\n            try {\n                conf.__bridge.shutdown();\n            }\n            catch (error)\n            {\n                console.error(error);\n            }\n        }\n        if (container && container.parentNode)\n        {\n            container.parentNode.removeChild(container);\n        }\n\n        if (conf.isMinimized())\n        {\n            this.__minimizedConferenceRoom.destruct();\n            this.__minimizedConferenceRoom = null;\n        }\n\n        // we are going to remove our resize calculator for our vh unit\n        window.removeEventListener('resize', conf.updateTelehealthFullVH);\n        conf.callerSettings = null;\n        conf.telehealthSessionData = null;\n        conf.__isShutdown = true;\n    };\n\n    this.updateTelehealthFullVH = function() {\n        // this functionality comes from https://stackoverflow.com/a/53883824 by manuel-84\n        // adapted from the answer on March 9th 2022 at 15:30.\n\n        let vh = window.innerHeight - 1;\n        document.documentElement.style.setProperty('--telehealth-full-vh', `${vh}px`);\n    };\n\n    this.initModalEvents = function(container)\n    {\n        var elements = document.getElementsByClassName('btn-telehealth-provider-close');\n        for (var i = 0; i < elements.length; i++)\n        {\n            elements[i].addEventListener('click', conf.handleCallHangup);\n        }\n    };\n\n    this.initWaitingRoomEvents = function(container)\n    {\n        conf.videoBar = new _video_bar_js__WEBPACK_IMPORTED_MODULE_2__.VideoBar(container, conf.getWaitingRoomVideoBarSettings());\n        conf.toggleJoinButton(conf.shouldEnableJoinButton());\n    };\n\n    this.togglePermissionBox = function(enabled)\n    {\n        let box = document.querySelector('#telehealth-container .permissions-box');\n        let boxRestartBtn = document.querySelector('#telehealth-container .permissions-box .restart-media-btn');\n        if (box && boxRestartBtn)\n        {\n            if (enabled) {\n                boxRestartBtn.addEventListener('click', conf.recaptureLocalMedia);\n                box.classList.remove('d-none');\n            } else {\n                box.classList.add('d-none');\n                boxRestartBtn.removeEventListener('click', conf.recaptureLocalMedia);\n            }\n        } else {\n            console.error(\"Could not find permissions box dom nodes\");\n        }\n    };\n\n    this.recaptureLocalMedia = function()\n    {\n        if (conf.__bridge && !conf.__bridge.isShutdown)\n        {\n            conf.__bridge.shutdown();\n        }\n        conf.startBridge(); // start the bridge over again since we couldn't capture the local media the first time.\n    };\n\n    this.shouldEnableJoinButton = function()\n    {\n        return conf.hasLocalPermissionsEnabled();\n    };\n\n    this.toggleJoinButton = function(enabled)\n    {\n        let btnJoin = document.querySelectorAll('.btn-comlink-conference-join');\n        if (btnJoin && btnJoin.length) {\n            for (let i = 0; i < btnJoin.length; i++) {\n                if (enabled) {\n                    btnJoin[i].addEventListener('click', conf.startConferenceRoom);\n                    btnJoin[i].classList.remove('disabled');\n                    btnJoin[i].classList.remove('btn-primary');\n                    btnJoin[i].classList.add('btn-success');\n                    btnJoin[i].disabled = false;\n                } else {\n                    btnJoin[i].removeEventListener('click', conf.startConferenceRoom);\n                    btnJoin[i].classList.add('disabled');\n                    btnJoin[i].classList.remove('btn-success');\n                    btnJoin[i].classList.add('btn-primary');\n                    btnJoin[i].disabled = true;\n                }\n            }\n        }\n    };\n\n    this.sessionClose = function()\n    {\n        let conf = this;\n        if (conf.isMinimized())\n        {\n            conf.destruct();\n        }\n        else {\n            // have to use jquery to grab the jquery event\n            jQuery(\"#telehealth-container\").on(\"hidden.bs.modal\", function () {\n                jQuery(\"#telehealth-container\").off(\"hidden.bs.modal\");\n                conf.destruct()\n            });\n            conf.roomModal.hide();\n        }\n    };\n\n    this.confirmSessionClose = function()\n    {\n        if (conf.room == conf.ROOM_TYPE_WAITING)\n        {\n            conf.sessionClose();\n        }\n        else {\n            let dialog = new _confirm_session_close_dialog_js__WEBPACK_IMPORTED_MODULE_0__.ConfirmSessionCloseDialog(translations, conf.telehealthSessionData.pc_eid, conf.getRemoteScriptLocation(), function() {\n                conf.sessionClose();\n            });\n            dialog.show();\n        }\n    };\n\n    this.shutdownProviderWaitingRoom =  function()\n    {\n        let container = document.getElementById('telehealth-container');\n        if (conf.__bridge && conf.__bridge.shutdown)\n        {\n            // catch any problems from the library so we can still clean up.\n            try {\n                conf.__bridge.shutdown();\n            }\n            catch (error)\n            {\n                console.error(error);\n            }\n        }\n        if (container && container.parentNode)\n        {\n            container.parentNode.removeChild(container);\n        }\n        conf.callerSettings = null;\n        conf.telehealthSessionData = null;\n    };\n\n    this.createModalWithContent = function(content)\n    {\n        let bootstrapModalTemplate = window.document.createElement('div');\n        // we use min-height 90vh until we get the bootstrap full screen modal in bootstrap 5\n        // TODO: @adunsulag now that both patient & portal are using the same dialog we can probably move this server side\n        // into the waiting room template.\n        bootstrapModalTemplate.innerHTML = `<div class=\"modal fade pl-0\" id=\"telehealth-container\" tabindex=\"-1\" aria-hidden=\"true\">\n              <div class=\"modal-dialog mw-100 ml-2 mr-2 mt-0 mt-md-1 mt-lg-2 mb-0\">\n                <div class=\"modal-content\">\n                  <div class=\"modal-header pt-2 pt-md-3 pb-2 pb-md-3\">\n                    <h5 class=\"modal-title\">` + jsText(translations.TELEHEALTH_MODAL_TITLE) + `</h5>\n                    <button type=\"button\" class=\"close btn-telehealth-provider-close\" aria-label=\"Close\">\n                      <span aria-hidden=\"true\">&times;</span>\n                    </button>\n                  </div>\n                  <div class=\"modal-body d-flex\">\n                  ${content}\n                  </div>\n                </div>\n              </div>\n            </div>`;\n        window.document.body.appendChild(bootstrapModalTemplate.firstElementChild);\n        var container = document.getElementById('telehealth-container');\n        conf.roomModal = new bootstrap.Modal(container, {keyboard: false, focus: true, backdrop: 'static'});\n        conf.initModalEvents(container);\n        return conf.roomModal;\n    };\n\n    this.startConferenceRoom = function()\n    {\n        conf.startProviderConferenceRoom();\n    };\n\n    this.startProviderConferenceRoom = function()\n    {\n        let container = document.getElementById('telehealth-container');\n        // now grab our video container in our modal\n\n\n        // let video = document.getElementById(\"local-video\");\n\n        conf.videoBar.destruct();\n\n        // now we are going to replace the modal content\n        let modalBody = container.querySelector('.modal-body');\n        // clear out the modal body\n        do {\n            modalBody.removeChild(modalBody.firstChild);\n        } while (modalBody.childNodes.length);\n        modalBody.innerHTML = conf.conferenceRoomTemplate;\n        conf.roomNode = modalBody.querySelector('.conference-room');\n        if (!conf.roomNode) {\n            console.error(\"Failed to find node with selector .conference-room from received data\");\n            alert(translations.SESSION_LAUNCH_FAILED);\n            conf.sessionClose();\n            return;\n        }\n        conf.roomNode.classList.add('active');\n\n        // now let's replace our template video container with our original video container from the waiting room.\n        let newLocalCallSlot = new _local_caller_slot__WEBPACK_IMPORTED_MODULE_9__.LocalCallerSlot(container.querySelector('.local-participant'), this.getLocalParticipant());\n        newLocalCallSlot.attach(this.__localCallSlot.getCurrentCallStream());\n        newLocalCallSlot.addCallerSelectListener((callerSlot) => {\n            conf.togglePinnedCallerId(callerSlot.getRemotePartyId());\n            conf.updateParticipantDisplays();\n        })\n        this.__localCallSlot = newLocalCallSlot;\n        //\n        // let conferenceVideo = document.getElementById('local-video');\n        // if (conferenceVideo && conferenceVideo.parentNode) {\n        //     conferenceVideo.parentNode.replaceChild(video, conferenceVideo);\n        // }\n        conf.videoBar = new _video_bar_js__WEBPACK_IMPORTED_MODULE_2__.VideoBar(this.getVideoBarContainer(), conf.getFullConferenceVideoBarSettings());\n        conf.inConferenceRoom = true;\n        conf.room = conf.ROOM_TYPE_CONFERENCE;\n\n        this.sessionUpdateInterval = setInterval(conf.updateConferenceRoomSession.bind(conf), conf.sessionUpdatePollingTime);\n        this.__presentationScreen = new _presentation_screen__WEBPACK_IMPORTED_MODULE_5__.PresentationScreen('presentation-screen');\n\n        this.sessionControlsActiveInterval = setInterval(conf.updateSessionControlsActive.bind(conf), conf.sessionControlsActiveTime);\n\n        // setup our minimize controls\n        conf.setupParticipantMinimizeControls(container);\n\n        conf.setupParticipantActiveEvents(container);\n\n        conf.updateConferenceRoomSession();\n    };\n\n    conf.updateSessionControlsActive = function() {\n        // if the interval has shutdown then we don't want to update anything anymore.\n        if (!conf.sessionControlsActiveInterval || conf.__isShutdown) {\n            return;\n        }\n\n        let date = new Date();\n        let lastActive = conf.lastActiveDate;\n        if (lastActive && (date.getTime() - lastActive.getTime() > conf.sessionControlsIdleTime)) {\n            conf.roomNode.classList.remove('active');\n            conf.roomNode.classList.add('idle');\n            conf.lastActive = null;\n        }\n    };\n\n    conf.setupParticipantActiveEvents = function() {\n        conf.lastActiveDate = new Date(); // set our initial active date\n        conf.roomNode.addEventListener('mousemove', conf.updateActive);\n        let presentationScreenContainer = conf.roomNode.querySelector('.remote-video-container');\n        if (!presentationScreenContainer) {\n            console.error(\"Failed to find node with selector '.remote-video-container'\");\n            return;\n        }\n        presentationScreenContainer.addEventListener('click', conf.updateActive);\n        // this.__presentationScreen.addSelectHandler(conf.updateActive);\n    };\n\n    conf.cleanupParticipantActiveEvents = function() {\n        if (conf.roomNode) {\n            conf.roomNode.removeEventListener('mousemove', conf.updateActive);\n        }\n    };\n\n    conf.updateActive = function() {\n        conf.lastActiveDate = new Date();\n        if (conf.roomNode) {\n            conf.roomNode.classList.remove('idle');\n            conf.roomNode.classList.add('active');\n        }\n    };\n\n    conf.toggleSidebar = function() {\n        if (conf.roomNode) {\n            let sidebar = conf.roomNode.querySelector('.sidebar')\n            if (sidebar.classList.contains('minimized')) {\n                sidebar.classList.remove('minimized');\n                sidebar.classList.add('maximized');\n            } else {\n                sidebar.classList.add('minimized');\n                sidebar.classList.remove('maximized');\n            }\n        }\n    };\n\n    conf.setupParticipantMinimizeControls = function(container) {\n        let btn = container.querySelector('.btn-list-minimize');\n        if (!btn) {\n            console.error(\"Failed to find minimize button with selector .btn-list-minimize\");\n            return;\n        }\n        btn.addEventListener('click', conf.toggleSidebar);\n\n        // now we need to do a media query check and initially minimize if we are at the point that we only\n        // have 400px of real estate on mobile...\n        var x = window.matchMedia(\"(max-width: 400px)\");\n        if (x.matches) {\n            conf.toggleSidebar();\n        }\n    };\n\n    this.updateLocalParticipantList = function() {\n        let eid = conf.telehealthSessionData.pc_eid;\n        window.top.restoreSession();\n        window.fetch(conf.getRemoteScriptLocation() + '?action=get_participant_list&pc_eid=' + encodeURIComponent(eid), {redirect: \"manual\"})\n            .then((request) => {\n                if (request.ok) {\n                    return request.json();\n                } else {\n                    throw new Error(\"Failed to receive valid server response from get_participant_list\");\n                }\n            })\n            .then(result => {\n                this.callerSettings.participantList = result.participantList;0\n            })\n            .catch(error => console.error(\"Failed to update local participant list. Third party invitations may not be up to date\", error));\n    };\n\n    this.updateConferenceRoomSession = function() {\n        let appt = conf.callerSettings.appointment || {};\n        let pc_eid = appt.eid || {};\n        window.top.restoreSession();\n        window.fetch(conf.getRemoteScriptLocation() + '?action=conference_session_update&pc_eid=' + encodeURIComponent(pc_eid), {redirect: \"manual\"})\n            .then((request) => {\n                if (request.ok) {\n                    return request.json();\n                } else {\n                    throw new Error(\"Failed to update session\");\n                }\n            })\n            .then(result => {\n                if (!conf.sessionUpdateInterval) {\n                    return; // we've been shut down and should just cancel at this point.\n                }\n               if (result.status !== 'success') {\n                   throw new Error(\"Failed to update session\");\n               } else {\n                   if (conf.__isShutdown) {\n                       // we've shutdown so ignore any updates here.\n                   }\n                   // grab our participant list\n\n                   // algorithm will be\n                   // 1. get the participant list\n                   // 2. check participant list that we have against the server participant list\n                   // 3. if participants are not the same\n                   //       at least one participant in our list of server participants is not in our local list\n                   // 4. call server for update list\n                   // 5. grab updated list and populate participants.\n                   let participants = result.participantList || [];\n                   let needsUpdate = participants.some(p => {\n                       let participant = this.callerSettings.participantList.find(cpl => {\n                           // don't think we need to update if we are in the room.\n                           return cpl.role == p.role && cpl.id == p.id; // && cpl.inRoom == p.inRoom\n                       });\n                       // server has participant that we don't have.\n                       return participant === undefined;\n                   });\n                   if (needsUpdate) {\n                       this.updateLocalParticipantList();\n                   }\n               }\n            })\n            .catch(error => console.error(\"Conference session update \", error));\n    };\n\n    this.cancelConferenceRoomSessionUpdateInterval = function()\n    {\n        if (conf.sessionUpdateInterval)\n        {\n            window.clearInterval(conf.sessionUpdateInterval);\n        }\n    };\n\n    this.getDefaultVideoBarSettings = function()\n    {\n        var noop = function() {};\n\n        return {\n            notes: false\n            ,notesCallback: noop\n            ,microphone: conf.buttonSettings.microphoneEnabled\n            ,microphoneCallback: conf.toggleMicrophone.bind(conf)\n            ,video: conf.buttonSettings.cameraEnabled\n            ,videoCallback: conf.toggleVideo.bind(conf)\n            ,expand: false\n            ,expandCallback: noop\n            ,hangup: false\n            ,hangupCallback: noop\n            ,screenshare: conf.buttonSettings.screensharingEnabled\n            ,screenshareCallback: conf.toggleScreenSharing.bind(conf)\n        };\n    };\n\n    this.getWaitingRoomVideoBarSettings = function()\n    {\n        return conf.getDefaultVideoBarSettings();\n    };\n\n    this.getMinimizedConferenceVideoBarSettings = function()\n    {\n        let settings = conf.getDefaultVideoBarSettings();\n        settings.expandCallback = conf.maximizeProviderConferenceCall.bind(conf);\n        settings.hangupCallback = conf.handleCallHangup.bind(conf);\n        settings.expand = true;\n        settings.notes = false;\n        settings.hangup = true;\n        conf.addSettingsForScreenshare(settings);\n        return settings;\n    };\n\n    this.addSettingsForScreenshare = function(settings) {\n        settings.screenshare = false;\n        if (this.__slots.length) {\n            // only show the button if we actually support the screenshare\n            if (window && window.navigator && window.navigator.mediaDevices\n                && window.navigator.mediaDevices.getDisplayMedia) {\n                settings.screenshare = true;\n            }\n        }\n    };\n\n    this.addSettingsForThirdPartyInvitations = function(settings) {\n        if (conf.features && conf.features.thirdPartyInvitations)\n        {\n            settings.invite = true;\n            settings.inviteCallback = conf.handleInviteCallback.bind(conf);\n        } else {\n            settings.invite = false;\n        }\n    };\n\n    this.getFullConferenceVideoBarSettings = function()\n    {\n        let settings = conf.getDefaultVideoBarSettings();\n        settings.hangupCallback = conf.handleCallHangup.bind(conf);\n        settings.notesCallback = conf.minimizeProviderConferenceCall.bind(conf);\n        settings.expand = false;\n        settings.notes = true;\n        settings.hangup = true;\n        conf.addSettingsForThirdPartyInvitations(settings);\n        conf.addSettingsForScreenshare(settings);\n        return settings;\n    };\n\n    this.handleInviteCallback = function() {\n        let dialog = new _add_patient_dialog__WEBPACK_IMPORTED_MODULE_7__.AddPatientDialog(this.apiCSRFToken, translations, conf.telehealthSessionData.pc_eid\n            , conf.getRemoteScriptLocation(), comlink.settings.fhirPath, conf.callerSettings.participantList\n            , function(callerSettings) {\n            // make suer we update our caller settings with the newly allowed patient so the provider can receive the call\n            if (callerSettings) {\n                conf.callerSettings = callerSettings;\n            }\n            });\n        dialog.show();\n    };\n\n    this.handleCallStartedEvent = function(call)\n    {\n        conf.toggleRemoteVideo(true);\n    };\n\n    this.resetConferenceVideoBar = function() {\n        if (conf.videoBar) {\n            conf.videoBar.destruct();\n        }\n        if (conf.__isShutdown) {\n            return; // nothing to do here as we are shutting down.\n        }\n        if (this.isMinimized()) {\n            conf.videoBar = this.__minimizedConferenceRoom.resetConferenceVideoBar(conf.getMinimizedConferenceVideoBarSettings());\n        } else {\n            conf.videoBar = new _video_bar_js__WEBPACK_IMPORTED_MODULE_2__.VideoBar(this.getVideoBarContainer(), conf.getFullConferenceVideoBarSettings());\n        }\n    };\n\n    this.getVideoBarContainer = function() {\n        var container = document.getElementById('telehealth-container');\n        return container.querySelector('.conference-room .telehealth-button-bar');\n    };\n\n    this.removeCallFromConference = function(call) {\n        if (call.getUserData() != null) {\n            /**\n             *\n             * @type {CallerSlot|null}\n             */\n            let callerSlot = call.getUserData();\n            if (call.isScreenSharing()) {\n                callerSlot.detachScreenshare();\n            }\n            else {\n                // when person is removed we can remove them from the call.\n                this.removeSlotForCall(call);\n                conf.setParticipantInCallRoomStatus(call.getRemotePartyId(), 'N');\n            }\n\n            this.updateParticipantDisplays();\n        }\n    };\n\n    // todo: look at removing this\n    this.removeSlotForCall = function(call) {\n        // if the user data is allocated then this is an existing call\n        if (call.getUserData() != null) {\n            let callerSlot = call.getUserData();\n            let remotePartyId = callerSlot.getRemotePartyId();\n            callerSlot.destruct(); // remove everything\n            // cleanup the slots\n            this.__slots = this.__slots.filter(s => s !== callerSlot);\n            // if the caller has left then we have nothing to pin here.\n            if (remotePartyId == this.__pinnedCallerUuid) {\n                this.togglePinnedCallerId(remotePartyId);\n            }\n            if (this.__slots.length && this.getCurrentCallerFocusId() == remotePartyId) {\n                // need to set our current caller focus id\n                // for now we will just set it to the first one on the call instead of trying to figure out\n                // the last known audio chatting\n                this.setCurrentCallerFocusId(this.__slots[0].getRemotePartyId());\n            }\n        }\n    };\n\n    this.hasRemoteParticipants = function() {\n        let hasParticipants = this.__slots.length > 0;\n        return hasParticipants;\n    }\n\n    // for the provider conference we end the call and we then show our waiting message\n    this.handleCallEndedEvent = function(call)\n    {\n        conf.removeCallFromConference(call);\n    };\n\n    this.handleActivityEvent = function(call) {\n        // first we only do this on a multi-party call where we have not pinned the caller\n        this.setCurrentCallerFocusId(call.getRemotePartyId());\n        this.updateParticipantDisplays();\n    };\n\n    this.handleCallHangup = function()\n    {\n        // if we hangup the call we maximize the window since the confirm dialog is embedded inside the\n        // main window.\n        if (conf.isMinimized()) {\n            conf.maximizeProviderConferenceCall({});\n        }\n        conf.confirmSessionClose();\n    };\n\n    this.minimizeProviderConferenceCall = function()\n    {\n        let container = document.getElementById('telehealth-container');\n        let defaultSettings = this.features.minimizeWindow || {enabled: true, defaultPosition: 'bottom-left'};\n        this.__minimizedConferenceRoom = new _minimized_conference_room__WEBPACK_IMPORTED_MODULE_8__.MinimizedConferenceRoom(container, defaultSettings);\n        this.__minimizedConferenceRoom.minimizeConferenceRoom(this.getMinimizedConferenceVideoBarSettings(), );\n        this.resetConferenceVideoBar(); // make sure we reset our controls here before we continue\n        conf.roomModal.hide();\n        this.updateParticipantDisplays();\n    };\n\n    this.maximizeProviderConferenceCall = function(evt)\n    {\n        if (this.isMinimized()) {\n            // save off our offset so we can restore it later\n            if (this.features.minimizeWindow) {\n                this.features.minimizeWindow.offset = this.__minimizedConferenceRoom.getCurrentOffset();\n            }\n            this.__minimizedConferenceRoom.maximizeConferenceRoom();\n            this.__minimizedConferenceRoom.destruct();\n            this.__minimizedConferenceRoom = null;\n\n\n            // everything's moved we can now display the larger video modal.\n            if (conf.roomModal) {\n                conf.roomModal.show();\n            } else {\n                console.error(\"Failed to find roomModal\");\n            }\n        }\n        this.updateParticipantDisplays();\n    };\n\n\n    this.toggleMicrophone = function(event)\n    {\n        let node = event.target;\n        if (!node.classList.contains('fa'))\n        {\n            node = node.querySelector('.fa');\n        }\n        let toggle = !conf.buttonSettings.microphoneEnabled;\n        conf.buttonSettings.microphoneEnabled = toggle;\n        node.dataset.enabled = toggle;\n        if (conf.__bridge && conf.__bridge.enableMicrophone) {\n            conf.__bridge.enableMicrophone(toggle);\n        } else {\n            console.error(\"__bridge is not initalized and cannot toggle microphone\");\n        }\n        toggleClass(node, toggle, 'fa-microphone','fa-microphone-slash');\n    };\n\n    this.toggleVideo = function(event)\n    {\n        let node = event.target;\n        if (!node.classList.contains('fa'))\n        {\n            node = node.querySelector('.fa');\n        }\n        let toggle = !conf.buttonSettings.cameraEnabled;\n        conf.buttonSettings.cameraEnabled = toggle;\n        // TODO: @adunsulag should we remove this reliance on the node.dataset here?\n        node.dataset.enabled = toggle;\n        if (conf.__bridge && conf.__bridge.enableCamera) {\n            conf.__bridge.enableCamera(toggle);\n        } else {\n            console.error(\"app is not initalized and cannot toggle microphone\");\n        }\n        toggleClass(node, toggle, 'fa-video','fa-video-slash');\n    };\n\n    this.toggleRemoteVideo = function(display)\n    {\n        var container = document.getElementById('telehealth-container');\n        var waitingContainer = container.querySelector('.waiting-container');\n\n        if (display)\n        {\n            waitingContainer.classList.add('d-none');\n            this.__presentationScreen.show();\n        } else {\n            waitingContainer.classList.remove('d-none');\n            this.__presentationScreen.hide();\n        }\n    };\n\n    this.toggleScreenSharing = function(evt) {\n        let participantList = this.getRemoteParticipantList();\n        let screenShareCallers = participantList.filter(p => p.inRoom == 'Y').map(p => p.uuid);\n        this.makeScreenshareCall(screenShareCallers);\n    };\n\n\n    // don't really need any class member variables here so we will let JS hoist this up.\n    function toggleClass(node, toggle, onClass, offClass)\n    {\n        if (toggle) {\n            node.classList.add(onClass);\n            node.classList.remove(offClass);\n        } else {\n            node.classList.add(offClass);\n            node.classList.remove(onClass);\n        }\n    }\n\n}\n\n\n//# sourceURL=webpack://comlink-telehealth-js/./src/conference-room.js?");

/***/ }),

/***/ "./src/configure-session-call-dialog.js":
/*!**********************************************!*\
  !*** ./src/configure-session-call-dialog.js ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"ConfigureSessionCallDialog\": function() { return /* binding */ ConfigureSessionCallDialog; }\n/* harmony export */ });\n\nclass ConfigureSessionCallDialog\n{\n    /**\n     *\n     * @type {bootstrap.Modal}\n     */\n    modal = null;\n\n    /**\n     *\n     * @type HTMLElement\n     */\n    container = null;\n\n    /**\n     *\n     * @type {number}\n     */\n    pc_eid = null;\n\n    /**\n     *\n     * @type {string}\n     */\n    scriptLocation = null;\n\n    /**\n     *\n     * @type {function}\n     */\n    closeCallback = null;\n\n    /**\n     * Because javascript is asinine in treating 'this' with bound functions we have these pointers.\n     * Modern JS allows us to 'overload' the 'get' parameter to handle this better but its still dumb.\n     * Makes me almost tempted to go back to jquery's on/off functionality.\n     * @type {function}\n     * @private\n     */\n    __cancelDialog = null;\n    __updateSettingsAndCloseDialog = null;\n\n    constructor(pc_eid, scriptLocation, closeCallback) {\n        this.pc_eid = pc_eid;\n        this.scriptLocation = scriptLocation;\n        this.closeCallback = closeCallback;\n        this.__cancelDialog = this.cancelDialog.bind(this);\n        this.__updateSettingsAndCloseDialog = this.updateSettingsAndCloseDialog.bind(this);\n    }\n\n    cancelDialog() {\n        let modal = this.modal;\n        this.destruct();\n        modal.hide();\n    }\n\n    processConfirmYesAction(evt) {\n        this.container.querySelector('.row-confirm').classList.add('d-none');\n        this.container.querySelector('.row-update-status').classList.remove('d-none');\n    }\n\n    sendSettingsSave(settings)\n    {\n        console.log(\"Saving session settings to \", settings);\n        let postData = Object.assign({pc_eid: this.pc_eid}, settings);\n        let scriptLocation = this.scriptLocation + \"action=save_session_settings\";\n\n        window.top.restoreSession();\n        window.fetch(scriptLocation,\n            {\n                method: 'POST'\n                ,headers: {\n                    'Content-Type': 'application/json'\n                }\n                ,body: postData\n                ,redirect: 'manual'\n            })\n            .then(result => {\n                if (!(result.ok && result.status == 200))\n                {\n                    alert(translations.APPOINTMENT_STATUS_UPDATE_FAILED);\n                    console.error(\"Failed to update session \" + this.pc_eid + \" with settings \" + settings);\n                }\n            });\n    };\n\n    getSettings() {\n        let thirdPartyEnabledNode = document.querySelector(\"input[name='enable-participant-invite']\");\n        let checked = thirdPartyEnabledNode && thirdPartyEnabledNode.checked;\n        let settings = {\n            \"enableThirdParty\": checked == true\n        };\n        return settings;\n    }\n    updateSettingsAndCloseDialog()\n    {\n\n        jQuery(this.container).on(\"hidden.bs.modal\", () => {\n            try {\n                jQuery(this.container).off(\"hidden.bs.modal\");\n                // settings saved and being returned to the callback.\n                this.closeCallback(this.getSettings());\n            }\n            catch (error)\n            {\n                console.error(error);\n            }\n            try {\n                this.sendSettingsSave(this.getSettings());\n            }\n            catch (updateError)\n            {\n                console.error(updateError);\n            }\n        });\n        this.modal.hide();\n    }\n\n    setupModal() {\n        let id = 'telehealth-container-configure-session';\n        // let bootstrapModalTemplate = window.document.createElement('div');\n        // we use min-height 90vh until we get the bootstrap full screen modal in bootstrap 5\n        this.container = document.getElementById(id);\n        this.modal = new bootstrap.Modal(this.container, {keyboard: false, focus: true, backdrop: 'static'});\n\n        let btns = this.container.querySelectorAll('.btn-telehealth-confirm-cancel');\n        for (var i = 0; i < btns.length; i++)\n        {\n            btns[i].addEventListener('click', this.__cancelDialog);\n        }\n        let updateSettings = this.container.querySelector('.btn-telehealth-session-update');\n        if (updateSettings)\n        {\n            updateSettings.addEventListener('click', this.__updateSettingsAndCloseDialog);\n        } else {\n            console.error(\"Could not find selector with .btn-telehealth-confirm-yes\");\n        }\n    }\n\n    resetModal() {\n    }\n\n    show() {\n        if (!this.modal) {\n            this.setupModal();\n        }\n\n        this.modal.show();\n    }\n\n    destruct() {\n        let btns = this.container.querySelectorAll('.btn-telehealth-confirm-cancel');\n        for (var i = 0; i < btns.length; i++)\n        {\n            btns[i].removeEventListener('click', this.__cancelDialog);\n        }\n        let updateSettings = this.container.querySelector('.btn-telehealth-session-update');\n        if (updateSettings)\n        {\n            updateSettings.removeEventListener('click', this.__updateSettingsAndCloseDialog);\n        } else {\n            console.error(\"Could not find selector with .btn-telehealth-confirm-yes\");\n        }\n    }\n}\n\n\n//# sourceURL=webpack://comlink-telehealth-js/./src/configure-session-call-dialog.js?");

/***/ }),

/***/ "./src/confirm-session-close-dialog.js":
/*!*********************************************!*\
  !*** ./src/confirm-session-close-dialog.js ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"ConfirmSessionCloseDialog\": function() { return /* binding */ ConfirmSessionCloseDialog; }\n/* harmony export */ });\n/**\n * Javascript Controller for the session close dialog window.  It handles the updating of the appointment status\n * and any other final actions that need to occur when a provider ends a session.\n *\n * @package openemr\n * @link      http://www.open-emr.org\n * @author    Stephen Nielson <snielson@discoverandchange.com>\n * @copyright Copyright (c) 2023 Comlink Inc <https://comlinkinc.com/>\n * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3\n */\nfunction ConfirmSessionCloseDialog(translations, pc_eid, scriptLocation, closeCallback)\n{\n    let dialog = this;\n    let modal = null;\n    let container = null;\n\n    this.cancelDialog = function()\n    {\n        // reset everything here.\n        let sections = container.querySelectorAll(\".hangup-section\");\n        let startSection = container.querySelector('.hangup-section.hangup-section-start');\n        if (sections && sections.length)\n        {\n            for (let i =0; i < sections.length; i++)\n            {\n                sections[i].classList.add(\"d-none\");\n            }\n        }\n        if (startSection)\n        {\n            startSection.classList.remove(\"d-none\");\n        }\n\n        modal.hide();\n    };\n\n    this.processConfirmYesAction = function(evt) {\n        container.querySelector('.row-confirm').classList.add('d-none');\n        container.querySelector('.row-update-status').classList.remove('d-none');\n    };\n\n    this.sendAppointmentStatusUpdate = function(status)\n    {\n        console.log(\"Setting appointment to status \", status);\n        let postData = \"action=set_appointment_status&pc_eid=\" + encodeURIComponent(pc_eid)\n            + \"&status=\" + encodeURIComponent(status);\n        window.top.restoreSession();\n        window.fetch(scriptLocation,\n            {\n                method: 'POST'\n                ,headers: {\n                    'Content-Type': 'application/x-www-form-urlencoded'\n                }\n                ,body: postData\n                ,redirect: 'manual'\n            })\n            .then(result => {\n                if (!(result.ok && result.status == 200))\n                {\n                    alert(translations.APPOINTMENT_STATUS_UPDATE_FAILED);\n                    console.error(\"Failed to update appointment \" + pc_eid + \" to status \" + status);\n                }\n            });\n    };\n\n    this.updateAppointmentStatusAndClose = function(status)\n    {\n\n        jQuery(container).on(\"hidden.bs.modal\", function () {\n            try {\n                jQuery(container).off(\"hidden.bs.modal\");\n                closeCallback();\n            }\n            catch (error)\n            {\n                console.error(error);\n            }\n            try {\n                if (status != 'CloseWithoutUpdating')\n                {\n                    dialog.sendAppointmentStatusUpdate(status);\n                }\n            }\n            catch (updateError)\n            {\n                console.error(updateError);\n            }\n        });\n        modal.hide();\n    };\n\n    this.processHangupSetting = function(evt)\n    {\n        let target = evt.currentTarget;\n        let status = target.dataset['status'] || 'CloseWithoutUpdating'; // - means none\n        dialog.updateAppointmentStatusAndClose(status);\n    };\n\n    this.processSetStatusFromSelector = function(evt)\n    {\n        let selector = container.querySelector('.appointment-status-update');\n        if (selector && selector.value)\n        {\n            dialog.updateAppointmentStatusAndClose(selector.value);\n        } else {\n            console.error(\"Failed to find selector .appointment-status-update node or value is not defined for node\");\n        }\n    };\n\n    this.show = function() {\n        let id = 'telehealth-container-hangup-confirm';\n        // let bootstrapModalTemplate = window.document.createElement('div');\n        // we use min-height 90vh until we get the bootstrap full screen modal in bootstrap 5\n        container = document.getElementById(id);\n        modal = new bootstrap.Modal(container, {keyboard: false, focus: true, backdrop: 'static'});\n\n        let btns = container.querySelectorAll('.btn-telehealth-confirm-cancel');\n        for (var i = 0; i < btns.length; i++)\n        {\n            btns[i].addEventListener('click', dialog.cancelDialog);\n        }\n        let confirmYes = container.querySelector('.btn-telehealth-confirm-yes');\n        if (confirmYes)\n        {\n            confirmYes.addEventListener('click', dialog.processConfirmYesAction);\n        } else {\n            console.error(\"Could not find selector with .btn-telehealth-confirm-yes\");\n        }\n\n        let statusOtherUpdateBtn = container.querySelector('.btn-telehealth-session-select-update');\n        if (statusOtherUpdateBtn)\n        {\n            statusOtherUpdateBtn.addEventListener('click', dialog.processSetStatusFromSelector);\n        }\n\n        btns = container.querySelectorAll('.btn-telehealth-session-close');\n        for (var i = 0; i < btns.length; i++)\n        {\n            btns[i].addEventListener('click', dialog.processHangupSetting);\n        }\n        modal.show();\n    }\n}\n\n\n//# sourceURL=webpack://comlink-telehealth-js/./src/confirm-session-close-dialog.js?");

/***/ }),

/***/ "./src/cvb.min.js":
/*!************************!*\
  !*** ./src/cvb.min.js ***!
  \************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"VideoBridge\": function() { return /* binding */ d; },\n/* harmony export */   \"VideoCall\": function() { return /* binding */ l; },\n/* harmony export */   \"getVersion\": function() { return /* binding */ c; }\n/* harmony export */ });\nfunction t(t, i) {\n    if (!t) throw new Error(i)\n}\n\nfunction i(t) {\n    try {\n        t()\n    } catch (t) {\n        console.log(\"Ignoring exception in user callback: \" + t)\n    }\n}\n\nclass s {\n    constructor(t, i) {\n        this.t = t, this.i = 1, this.h = i\n    }\n\n    get() {\n        return this.t\n    }\n\n    incRef() {\n        ++this.i\n    }\n\n    decRef() {\n        0 == --this.i && (this.h(this.t), this.h = null, this.t = null)\n    }\n}\n\nclass e {\n    constructor(t) {\n        this.o = t, this.l = \"\", this.u = new TextDecoder(\"utf-8\"), this._ = !1\n    }\n\n    cancel() {\n        this.o.cancel()\n    }\n\n    eof() {\n        return this._\n    }\n\n    v() {\n        const t = this.l.indexOf(\"\\r\\n\");\n        if (-1 == t) return null;\n        const i = this.l.substr(0, t);\n        return this.l = this.l.substr(t + 2), i\n    }\n\n    p() {\n        return this.o.read().then((t => {\n            if (t.done) return this._ = !0, Promise.resolve(this.l);\n            this.l += this.u.decode(t.value);\n            const i = this.v();\n            return i ? Promise.resolve(i) : this.p()\n        }))\n    }\n\n    readEvent() {\n        if (this._) return Promise.reject();\n        const t = this.v();\n        return t ? Promise.resolve(t) : this.p()\n    }\n}\n\nclass h {\n    constructor(t) {\n        this.g = t\n    }\n\n    I(t, i) {\n        return fetch(this.g + t, {\n            method: \"POST\",\n            cache: \"no-cache\",\n            headers: {\"Content-Type\": \"application/json\"},\n            body: JSON.stringify(i)\n        }).then((t => t.ok ? t.json() : Promise.reject(t.status)))\n    }\n\n    C(t, i) {\n        return fetch(this.g + t, {\n            method: \"POST\",\n            cache: \"no-cache\",\n            headers: {\"Content-Type\": \"application/json\"},\n            body: JSON.stringify(i)\n        })\n    }\n\n    createBridge(t, i, s) {\n        const e = {userId: t, passwordHash: i, type: s};\n        return fetch(this.g + \"/client/createBridge\", {\n            method: \"POST\",\n            cache: \"no-cache\",\n            headers: {\"Content-Type\": \"application/json\"},\n            body: JSON.stringify(e)\n        })\n    }\n\n    invite(t) {\n        return this.C(\"/client/invite\", {callId: t})\n    }\n\n    call(t, i, s) {\n        return this.I(\"/client/call\", {callerId: t, calleeId: i, isScreenSharing: s})\n    }\n\n    accept(t, i) {\n        return this.C(\"/client/accept\", {callId: t, token: i})\n    }\n\n    reject(t, i) {\n        return this.C(\"/client/reject\", {callId: t, token: i})\n    }\n\n    offer(t, i, s) {\n        return this.C(\"/client/offer\", {callId: t, sdp: s, token: i})\n    }\n\n    answer(t, i, s) {\n        return this.C(\"/client/answer\", {callId: t, sdp: s, token: i})\n    }\n\n    ice(t, i, s) {\n        return this.C(\"/client/ice\", {callId: t, candidate: i, token: s})\n    }\n\n    end(t, i) {\n        return this.C(\"/client/end\", {callId: t, token: i})\n    }\n}\n\nconst n = new class {\n    constructor() {\n        this.m = [], this.k = 0, this.S = -1\n    }\n\n    P() {\n        this.m.forEach((t => t.func()))\n    }\n\n    T() {\n        this.S = setInterval((() => this.P()), 500)\n    }\n\n    V() {\n        clearInterval(this.S), this.S = -1\n    }\n\n    addTask(t) {\n        const i = this.k++, s = {id: i, func: t};\n        return this.m.push(s), 1 == this.m.length && this.T(), i\n    }\n\n    removeTask(t) {\n        const i = this.m.findIndex((i => i.id == t));\n        -1 != i && (this.m.splice(i, 1), 0 == this.m.length && this.V())\n    }\n}, r = new class {\n    newAudioContext() {\n        return new (window.AudioContext || window.webkitAudioContext)\n    }\n};\n\nclass a {\n    constructor() {\n        this.L = -1, this.A = r.newAudioContext(), this.j = this.A.createAnalyser(), this.j.fftSize = 2048, this.j.minDecibels = -100, this.j.maxDecibels = 0, this.j.smoothingTimeConstant = .8, this.B = new Uint8Array(this.j.frequencyBinCount), this.R = null, this.db = 0, this.ondbthresholdexceeded = t => {\n        }, this.dbthreshold = -50\n    }\n\n    connect(t) {\n        let i;\n        try {\n            i = this.A.createMediaStreamSource(t), i.connect(this.j), this.j.connect(this.A.destination)\n        } catch (t) {\n            return\n        }\n        -1 == this.L && (this.L = n.addTask((() => this.O()))), this.R && this.R.disconnect(), this.R = i\n    }\n\n    disconnect() {\n        -1 != this.L && (n.removeTask(this.L), this.R.disconnect(), this.R = null, this.L = -1)\n    }\n\n    O() {\n        this.j.getByteFrequencyData(this.B);\n        let t = -100;\n        for (let i = 0; i < this.B.length; ++i) t = Math.max(t, this.B[i]);\n        this.db = .3921568627 * t - 100, this.db >= this.dbthreshold && i((() => this.ondbthresholdexceeded(this)))\n    }\n}\n\nconst o = \"Copyright (c) 2023 Comlink Inc.\";\n\nfunction c() {\n    return \"1.1.6\"\n}\n\nclass l {\n    constructor(t) {\n        this.U = t.isInbound, this.N = t.isScreenSharing, t.basedOnCall && (this.M = t.basedOnCall.M, this.M.incRef()), this.D = t.remotePartyId, this.J = t.bridge, this.H = t.callId, this.K = t.config, this.F = t.token, this.G = null, this.W = null, this.q = null, this.o = null, this.X = null, this.Y = null, this.Z = [], t.isInbound ? this.$ = 1 : this.$ = 0, this.oncallstarted = t => this.tt(\"Unhandled event: call started: \" + t.H), this.oncallrejected = t => this.tt(\"Unhandled event: call rejected: \" + t.H), this.oncallended = t => this.tt(\"Unhandled event: call ended: \" + t.H), this.onstreamupdated = (t, i) => this.tt(\"Unhandled event: stream updated: \" + t.H), this.onparticipantlistupdated = (t, i) => this.tt(\"Unhandled event: participant list updated: \" + t.H), this.onviewportlayoutupdated = (t, i) => this.tt(\"Unahndled event: viewport layout updated: \" + i), this.onfacialrecognizerresults = (t, i) => this.tt(\"Unhandled event: facial recognizer results: \" + i)\n    }\n\n    it(t) {\n        console.log(\"VC/\" + this.H + \": \" + t)\n    }\n\n    st(t) {\n        console.error(\"VC/\" + this.H + \": \" + t)\n    }\n\n    tt(t) {\n        console.warn(\"VC/\" + this.H + \": \" + t)\n    }\n\n    et() {\n        return this.G = new RTCPeerConnection(this.K), this.G.onicecandidate = t => this.ht(t), this.G.ontrack = t => this.nt(t), this.G.onremovetrack = t => this.rt(t), this.N ? this.U ? Promise.resolve(this) : this.ot() : this.ct()\n    }\n\n    lt(t, i) {\n        this.G.addTrack(t, i), t.addEventListener(\"ended\", (() => this.dt(t)))\n    }\n\n    ut(t) {\n        t.getTracks().forEach((i => this.lt(i, t)))\n    }\n\n    ct() {\n        return this.J.getLocalMediaStream().then((t => {\n            this.ut(t)\n        }))\n    }\n\n    ot() {\n        if (!this.M) {\n            const t = {video: {cursor: \"always\"}, audio: !0};\n            return navigator.mediaDevices.getDisplayMedia(t).then((t => {\n                this.ut(t), this.M = new s(t, (t => {\n                    t.getTracks().forEach((t => t.stop()))\n                })), i((() => this.onstreamupdated(this, t)))\n            }))\n        }\n        {\n            const t = this.M.get();\n            this.ut(t), i((() => this.onstreamupdated(this, t)))\n        }\n    }\n\n    _t() {\n        6 != this.$ && (this.$ = 6, this.J.vt(this), this.q && (this.q.disconnect(), this.q = null), this.M && this.M.decRef(), this.G.close(), this.G = null)\n    }\n\n    gt(t) {\n        return 6 != this.$ && 4 != this.$ ? (this._t(), i((() => this.oncallended(this))), t ? this.J.ft.end(this.H, this.F).then((() => this)) : this) : Promise.resolve(this)\n    }\n\n    bt(i) {\n        switch (t(\"CALL\" == i.type, 'Bad event type. \"CALL\" expected.'), i.name) {\n            case\"accept\":\n                this.wt();\n                break;\n            case\"end\":\n                this.It();\n                break;\n            case\"reject\":\n                this.yt();\n                break;\n            case\"sdp\":\n                this.Ct(i.sdp, i.action);\n                break;\n            case\"ice\":\n                this.kt(i.iceCandidate);\n                break;\n            case\"participants\":\n                this.St(i.userIds);\n                break;\n            case\"viewportLayout\":\n                this.Et({frameWidth: i.frameWidth, frameHeight: i.frameHeight, viewports: i.viewports});\n                break;\n            case\"facialRecognition\":\n                this.Pt({callId: i.tagCallId, tag: i.tag, confidence: i.confidence});\n                break;\n            default:\n                throw new Error(\"Bad call state\")\n        }\n    }\n\n    St(t) {\n        this.X = t, i((() => this.onparticipantlistupdated(this, this.X)))\n    }\n\n    Et(t) {\n        this.Y = t, i((() => this.onviewportlayoutupdated(this, this.Y)))\n    }\n\n    Pt(t) {\n        i((() => this.onfacialrecognizerresults(this, t)))\n    }\n\n    kt(t) {\n        this.G.remoteDescription ? this.G.addIceCandidate(t) : this.Z.push(t)\n    }\n\n    nt(t) {\n        this.o = t.streams[0], this.q && this.q.connect(this.o), i((() => this.onstreamupdated(this, this.o)))\n    }\n\n    rt(t) {\n    }\n\n    dt(t) {\n        this.gt(!0)\n    }\n\n    It() {\n        this.gt(!1)\n    }\n\n    wt() {\n        this.G.createOffer({\n            offerToReceiveVideo: !0,\n            offerToReceiveAudio: !0\n        }).then((t => this.G.setLocalDescription(t))).then((() => this.J.ft.offer(this.H, this.F, this.G.localDescription.sdp))).catch((t => {\n            throw this.Tt(t), t\n        })), i((() => this.oncallstarted(this)))\n    }\n\n    yt() {\n        this.J.vt(this), this.$ = 4, i((() => this.oncallrejected(this)))\n    }\n\n    Ct(t, i) {\n        const s = new RTCSessionDescription({type: i, sdp: t});\n        \"offer\" == i ? this.G.setRemoteDescription(s).then((() => (this.Vt(), this.G.createAnswer()))).then((t => this.G.setLocalDescription(t))).then((() => this.J.ft.answer(this.H, this.F, this.G.localDescription.sdp))).then((t => (this.$ = 3, t))).catch((t => {\n            throw this.Tt(t), t\n        })) : \"answer\" == i && this.G.setRemoteDescription(s).then((() => {\n            this.Vt(), this.$ = 3\n        })).catch((t => {\n            throw this.Tt(t), t\n        }))\n    }\n\n    Vt() {\n        this.Z.forEach((t => {\n            this.G.addIceCandidate(t)\n        })), this.Z = []\n    }\n\n    ht(t) {\n        if (t.candidate) try {\n            this.J.ft.ice(this.H, t.candidate, this.F)\n        } catch (t) {\n            this.tt(\"failed to transmit ICE candidate\")\n        }\n    }\n\n    Tt(t) {\n        this.$ = 4, this.st(\"panic: \" + t.message)\n    }\n\n    getParticipantList() {\n        return this.X\n    }\n\n    getViewportLayout() {\n        return this.Y\n    }\n\n    getCallId() {\n        return this.H\n    }\n\n    getVideoBridge() {\n        return this.J\n    }\n\n    getRemotePartyId() {\n        return this.D\n    }\n\n    isInbound() {\n        return this.U\n    }\n\n    setUserData(t) {\n        this.W = t\n    }\n\n    getUserData() {\n        return this.W\n    }\n\n    isScreenSharing() {\n        return this.N\n    }\n\n    attachActivityMonitor(s, e) {\n        t(null == this.q, \"Activity notifier already attached\"), t(null != e, \"Activity monitor callback not defined\"), this.q = new a, this.q.dbthreshold = s, this.q.ondbthresholdexceeded = t => i((() => e(this))), this.o && this.q.connect(this.o)\n    }\n\n    getSoundLevel() {\n        return this.q ? this.q.db : NaN\n    }\n\n    start() {\n        return t(0 == this.$, \"Call already initialized\"), this.$ = 1, this.it(\"starting\"), this.J.ft.call(this.J.getUserId(), this.D, this.N).then((t => (this.H = t.callId, this.K = t.config, this.F = t.token, this.et()))).then((() => this.J.ft.invite(this.H))).then((() => (this.$ = 2, this.J.Lt(this), this))).catch((t => {\n            throw this.Tt(t), t\n        }))\n    }\n\n    accept() {\n        return t(1 == this.$, \"Invalid call state\"), t(this.U, \"Not an inbound call\"), this.it(\"accepting\"), this.et().then((() => this.J.ft.accept(this.H, this.F))).then((t => (this.$ = 2, this))).catch((t => {\n            throw this.Tt(t), t\n        }))\n    }\n\n    reject() {\n        return t(1 == this.$, \"Invalid call state\"), t(this.U, \"Not an inbound call\"), this.it(\"rejecting\"), this.J.ft.reject(this.H, this.F).then((t => (this.$ = 5, this.J.vt(this), this))).catch((t => {\n            throw this.Tt(t), t\n        }))\n    }\n\n    stop() {\n        return this.gt(!0)\n    }\n\n    muteRemoteAudio(i) {\n        t(\"boolean\" == typeof i, \"Expected a boolean value\"), this.G.getReceivers().forEach((t => {\n            \"audio\" == t.track.kind && (t.track.enabled = i)\n        }))\n    }\n}\n\nclass d {\n    constructor(t) {\n        this.At = t.userId, this.jt = t.type, this.Bt = t.passwordHash, this.ft = new h(t.serviceUrl || \"\"), this.Rt = !1, this.Ot = {}, this.Ut = !1, this.Nt = !1, this.xt = null, this.Mt = null, this.onbridgeactive = t => console.log(\"onbridgeactive event not handled\"), this.onbridgeinactive = t => console.log(\"onbridgeinactive event not handled\"), this.onbridgefailure = t => console.log(\"onbridgefailure event not handled\"), this.onincomingcall = t => {\n            console.log(\"Inbound call event not handled; call rejected.\"), t.reject()\n        }\n    }\n\n    Tt(t) {\n        console.log(\"Catastrophic bridge failure: \" + t), i((() => this.onbridgefailure(this))), this.shutdown()\n    }\n\n    Dt() {\n        this.Rt ? this.Tt(new Error(\"Event stream closed unexpectedly\")) : i((() => this.onbridgeinactive(this)))\n    }\n\n    Jt() {\n        this.xt.readEvent().then((t => {\n            if (this.xt.eof()) this.Dt(); else {\n                try {\n                    const i = JSON.parse(t);\n                    this.bt(i)\n                } catch (t) {\n                    return void this.Tt(t)\n                }\n                this.Jt()\n            }\n        }))\n    }\n\n    zt(t) {\n        const i = this.Ot[t.callId];\n        i ? i.bt(t) : console.log(\"Invalid call identifier in the event stream: \" + t.callId)\n    }\n\n    Ht(t) {\n        const s = new l({\n            bridge: this,\n            callId: t.callId,\n            isInbound: !0,\n            isScreenSharing: t.isScreenSharing,\n            remotePartyId: t.callerId,\n            config: t.config,\n            token: t.token\n        });\n        this.Lt(s), i((() => this.onincomingcall(s)))\n    }\n\n    Kt(t) {\n        this.Rt || (this.Rt = !0, i((() => this.onbridgeactive(this))))\n    }\n\n    bt(t) {\n        switch (console.log(t), t.type) {\n            case\"INCOMING\":\n                this.Ht(t);\n                break;\n            case\"KEEPALIVE\":\n                this.Kt(t);\n                break;\n            case\"CALL\":\n                this.zt(t);\n                break;\n            default:\n                this.Tt(new Error(\"Bad event type: \" + t.type + \". Corrupt stream?\"))\n        }\n    }\n\n    Ft() {\n        Object.values(this.Ot).forEach((t => t._t())), this.Ot = {}\n    }\n\n    Lt(t) {\n        this.Ot[t.getCallId()] = t\n    }\n\n    vt(t) {\n        const i = t.getCallId();\n        this.Ot.hasOwnProperty(i) && delete this.Ot[i]\n    }\n\n    getUserId() {\n        return this.At\n    }\n\n    getCalls() {\n        return Object.values(this.Ot)\n    }\n\n    hasCamera() {\n        return this.Ut\n    }\n\n    hasMicrophone() {\n        return this.Nt\n    }\n\n    getCallById(t) {\n        return this.Ot[t]\n    }\n\n    isActive() {\n        return this.Rt\n    }\n\n    getLocalMediaStream() {\n        return t(this.Rt, \"VideoBridge not active\"), this.Mt ? Promise.resolve(this.Mt) : navigator.mediaDevices.enumerateDevices().then((t => {\n            var i = {};\n            return null != t.find((t => \"videoinput\" == t.kind)) && (this.Ut = !0, i.video = {\n                width: 800,\n                height: 600\n            }), null != t.find((t => \"audioinput\" == t.kind)) && (this.Nt = !0, i.audio = {channels: 1}), navigator.mediaDevices.getUserMedia(i)\n        })).then((t => (this.Mt = t, t)))\n    }\n\n    closeLocalMediaStream() {\n        t(this.Rt, \"VideoBridge not active\"), this.Mt && (this.Mt.getTracks().forEach((t => t.stop())), this.Mt = null, this.Nt = !1, this.Ut = !1)\n    }\n\n    enableCamera(i) {\n        t(this.Rt, \"Video bridge not active\"), t(\"boolean\" == typeof i, \"Expected a boolean value\"), this.Ut && this.Mt.getTracks().forEach((t => {\n            \"live\" == t.readyState && \"video\" === t.kind && (t.enabled = i)\n        }))\n    }\n\n    enableMicrophone(i) {\n        t(this.Rt, \"Video bridge not active\"), t(\"boolean\" == typeof i, \"Expected a boolean value\"), this.Nt && this.Mt.getTracks().forEach((t => {\n            \"live\" == t.readyState && \"audio\" === t.kind && (t.enabled = i)\n        }))\n    }\n\n    start() {\n        t(!this.Rt, \"Video bridge already active\"), console.log(\"CVB v1.1.6. \" + o), this.ft.createBridge(this.At, this.Bt, this.jt).then((t => t.body)).then((t => {\n            this.xt = new e(t.getReader()), this.Jt()\n        })).catch((t => {\n            console.error(\"Video bridge creation failure: \" + t), i((() => this.onbridgefailure(this))), this.Tt(t)\n        }))\n    }\n\n    shutdown() {\n        t(this.Rt, \"Video bridge not active\"), console.log(\"CVB v1.1.6. \" + o), Object.values(this.Ot).slice().forEach((t => t.stop())), this.closeLocalMediaStream(), this.Rt = !1, this.xt.cancel()\n    }\n\n    createVideoCall(i) {\n        return t(this.Rt, \"Video bridge not active\"), new l({\n            bridge: this,\n            isInbound: !1,\n            isScreenSharing: !1,\n            remotePartyId: i\n        })\n    }\n\n    createScreenSharingCall(i, s) {\n        return t(this.Rt, \"Video bridge not active\"), new l({\n            bridge: this,\n            isInboud: !1,\n            isScreenSharing: !0,\n            remotePartyId: i,\n            basedOnCall: s\n        })\n    }\n}\n\n\n\n\n//# sourceURL=webpack://comlink-telehealth-js/./src/cvb.min.js?");

/***/ }),

/***/ "./src/local-caller-slot.js":
/*!**********************************!*\
  !*** ./src/local-caller-slot.js ***!
  \**********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"LocalCallerSlot\": function() { return /* binding */ LocalCallerSlot; }\n/* harmony export */ });\n/**\n * Javascript Controller for the local (current) user in the video session.  It imitates a regular caller slot so that\n * actions can be applied to both objects.\n *\n * @package openemr\n * @link      http://www.open-emr.org\n * @author    Stephen Nielson <snielson@discoverandchange.com>\n * @copyright Copyright (c) 2023 Comlink Inc <https://comlinkinc.com/>\n * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3\n */\nclass LocalCallerSlot {\n\n    /**\n     *\n     * @type HTMLElement\n     * @private\n     */\n    __container = null;\n\n    /**\n     *\n     * @type HTMLVideoElement\n     * @private\n     */\n    __localVideoElement = null;\n\n    /**\n     *\n     * @type {Array}\n     * @private\n     */\n    __selectCallbacks = [];\n\n    /**\n     * The participant object\n     * @type object\n     * @private\n     */\n    __localParticipant = null;\n\n    /**\n     * True if the video is pinned\n     * @type {boolean}\n     * @private\n     */\n    __isPinned = false;\n\n    constructor(container, participant) {\n        this.__container = container;\n        this.__localVideoElement = container.querySelector('.local-video');\n        this.__selectCallbacks = [];\n        this.__isPinned = false;\n        this.__localParticipant = participant;\n\n        container.addEventListener('click', this.handleSelectEvent.bind(this));\n    }\n\n    attach(stream) {\n        this.__localVideoElement.srcObject = stream;\n        this.__localVideoElement.play().catch(e => {\n            console.error(\"Failed to play local video error object \", e);\n        })\n    }\n\n    getRemotePartyId() {\n        if (this.__localParticipant) {\n            return this.__localParticipant.uuid;\n        }\n        return null;\n    }\n\n    getParticipant() {\n        return this.__localParticipant;\n    }\n\n    getCurrentCallStream() {\n        if (this.__localVideoElement) {\n            return this.__localVideoElement.srcObject;\n        }\n        return null;\n    }\n\n\n    setMuted(isMuted) {\n        this.__localVideoElement.muted = true;\n    }\n\n    hasMediaStream() {\n        return this.__localVideoElement && this.__localVideoElement.srcObject != null;\n    }\n\n    stop() {\n        if (this.__localVideoElement) {\n            this.__localVideoElement.pause();\n            this.__localVideoElement.srcObject = null;\n        }\n    }\n\n    hide() {\n        this.__container.classList.add('d-none');\n    }\n\n    show() {\n        this.__container.classList.remove('d-none');\n    }\n\n\n    handleSelectEvent(evt) {\n        this.__selectCallbacks.forEach(cb => cb(this));\n    }\n\n    addCallerSelectListener(callback) {\n        this.__selectCallbacks.push(callback);\n    }\n\n\n    setPinnedStatus(status) {\n        this.__isPinned = status;\n        if (status) {\n            this.__container.classList.add('pinned');\n        } else {\n            this.__container.classList.remove('pinned');\n        }\n    }\n\n    isPinned() {\n        return this.__isPinned;\n    }\n}\n\n//# sourceURL=webpack://comlink-telehealth-js/./src/local-caller-slot.js?");

/***/ }),

/***/ "./src/minimized-conference-room.js":
/*!******************************************!*\
  !*** ./src/minimized-conference-room.js ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"MinimizedConferenceRoom\": function() { return /* binding */ MinimizedConferenceRoom; }\n/* harmony export */ });\n/* harmony import */ var _video_bar_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./video-bar.js */ \"./src/video-bar.js\");\n/**\n * Javascript Controller for the minimized session window.  It handles both minimizing and maximizing of a conference\n * session room.\n *\n * @package openemr\n * @link      http://www.open-emr.org\n * @author    Stephen Nielson <snielson@discoverandchange.com>\n * @copyright Copyright (c) 2023 Comlink Inc <https://comlinkinc.com/>\n * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3\n */\n\n\nclass MinimizedConferenceRoom {\n    __isMinimized = false;\n    container = null;\n\n    /**\n     *\n     * @type {HTMLElement}\n     */\n    participantList = null;\n\n    /**\n     *\n     * @type {VideoBar}\n     */\n    videoBar = null;\n\n    /**\n     *\n     * @type HTMLElement\n     */\n    minimizedConferenceNode = null;\n\n    /**\n     *\n     * @type 'top-left'|'bottom-left'|'top-right'|'bottom-right'\n     */\n    defaultPosition = 'bottom-right';\n\n    initialOffset = null;\n\n    constructor(container, defaultSettings) {\n        this.container = container;\n        this.defaultPosition = defaultSettings.defaultPosition || 'bottom-right';\n        if (defaultSettings.offset) {\n            this.initialOffset = defaultSettings.offset;\n        }\n    }\n\n    isMinimized() {\n        return this.__isMinimized;\n    }\n\n    resetConferenceVideoBar(minimizedSettings) {\n        if (this.videoBar) {\n            this.videoBar.destruct();\n            this.videoBar = null;\n        }\n        let conferenceVideoBar = this.minimizedConferenceNode.querySelector(\".telehealth-button-bar\");\n        this.videoBar = new _video_bar_js__WEBPACK_IMPORTED_MODULE_0__.VideoBar(conferenceVideoBar, minimizedSettings);\n        return this.videoBar;\n    };\n\n    minimizeConferenceRoom(minimizedVideoButtonSettings) {\n\n        let className = \"minimized-telehealth-video-template\";\n        let templateNode = this.container.querySelector(\".\" + className);\n        if (!templateNode) {\n            throw new Error(\"Failed to find template node with class .\" + className);\n        }\n        let template = templateNode.cloneNode(true);\n\n        // grab every dom node in the waiting room that is not the patient video\n        // grab the video and shrink it to bottom left window\n        // shrink container to be the size of the video\n        template.id = \"minimized-telehealth-video\";\n        template.classList.remove('d-none');\n        template.classList.remove(className);\n        template.classList.add(this.defaultPosition);\n\n        window.document.body.appendChild(template);\n        this.minimizedConferenceNode = template;\n\n        // let's grab the participant list and append it\n        this.participantList = this.container.querySelector('.participant-list-container');\n        template.prepend(this.participantList);\n        if (this.participantList.dataset['classMinimize']) {\n            this.participantList.className = this.participantList.dataset['classMinimize'];\n        }\n\n        if (this.initialOffset && window.setInteractorPosition) {\n            // this is what the drag drop library does...\n            window.setInteractorPosition(this.initialOffset.top, this.initialOffset.left, this.minimizedConferenceNode);\n        }\n\n        // now make the video container draggable\n        if (window.initDragResize)\n        {\n            // let's initialize our drag action here.\n            window.initDragResize();\n        }\n\n        this.__isMinimized = true;\n    }\n\n    getCurrentOffset() {\n        let top = 0;\n        let left = 0;\n        top = this.minimizedConferenceNode.dataset.x;\n        left = this.minimizedConferenceNode.dataset.y;\n        return {\n            top: top\n            ,left: left\n        };\n    }\n\n    maximizeConferenceRoom() {\n        // remove the event listener\n        var remoteVideoContainer = this.container.querySelector('.sidebar');\n\n        // now let's move the video and cleanup the old container here\n        // if (remoteVideo && remoteVideoContainer) {\n        if (this.participantList && remoteVideoContainer) {\n\n            // var oldContainer = remoteVideo.parentNode;\n            var oldContainer = this.minimizedConferenceNode;\n            this.videoBar.destruct();\n            // remoteVideoContainer.prepend(remoteVideo);\n            remoteVideoContainer.appendChild(this.participantList);\n            if (this.participantList.dataset['classMaximize']) {\n                this.participantList.className = this.participantList.dataset['classMaximize'];\n            }\n\n            // need to clean up the original minimize container we created here\n            if (oldContainer && oldContainer.parentNode)\n            {\n                oldContainer.parentNode.removeChild(oldContainer);\n            }\n            this.minimizedConferenceNode = null;\n        } else {\n            console.error(\"Failed to find remote video or remote video container\");\n        }\n        this.__isMinimized = false;\n    }\n\n    destruct() {\n        // clean up our node pointers\n        this.participantList = null;\n        this.container = null;\n\n        // clean up minimized elements now too if we have them.\n        let minimizedContainer = document.getElementById('minimized-telehealth-video');\n        if (minimizedContainer && minimizedContainer.parentNode)\n        {\n            minimizedContainer.parentNode.removeChild(minimizedContainer);\n        }\n        this.__isMinimized = false;\n    }\n}\n\n//# sourceURL=webpack://comlink-telehealth-js/./src/minimized-conference-room.js?");

/***/ }),

/***/ "./src/patient-conference-room.js":
/*!****************************************!*\
  !*** ./src/patient-conference-room.js ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"PatientConferenceRoom\": function() { return /* binding */ PatientConferenceRoom; }\n/* harmony export */ });\n/* harmony import */ var _conference_room_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./conference-room.js */ \"./src/conference-room.js\");\n/**\n * Javascript Controller for the Patient conference room which extends the room conference controller\n * (though a form of prototype/object delegation)\n *\n * @package openemr\n * @link      http://www.open-emr.org\n * @author    Stephen Nielson <snielson@discoverandchange.com>\n * @copyright Copyright (c) 2023 Comlink Inc <https://comlinkinc.com/>\n * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3\n */\n\n\n\nfunction PatientConferenceRoom(apiCSRFToken, enabledFeatures, translations,scriptLocation) {\n    let patientConferenceRoom = new _conference_room_js__WEBPACK_IMPORTED_MODULE_0__.ConferenceRoom(apiCSRFToken, enabledFeatures, translations, scriptLocation);\n    let parentDestruct = patientConferenceRoom.destruct;\n    let checkProviderReadyForPatientInterval = null;\n    let hostDelayCheckTimeout = null;\n    let providerIsReady = false;\n\n    function checkProviderReadyForPatient()\n    {\n        let pc_eid = patientConferenceRoom.telehealthSessionData.pc_eid;\n        window.top.restoreSession();\n        window.fetch(scriptLocation + '?action=patient_appointment_ready&eid=' + encodeURIComponent(pc_eid), {redirect: \"manual\"})\n            .then(result => {\n                if (result.ok) {\n                    return result.json();\n                } else {\n                    throw new Error(\"Failed to get response back from server\")\n                }\n            })\n            .then(apptReadyData => {\n                if (patientConferenceRoom.__shutdown || !checkProviderReadyForPatientInterval) {\n                    return; // don't do anything else here as we have shutdown inbetween the callback.\n                }\n                if (apptReadyData.session)\n                {\n                    // provider being ready is just one test, local camera permissions also must be checked\n                    providerIsReady = apptReadyData.session.providerReady === \"1\";\n\n                    // we update the calleeUuid here in case another provider takes over the appointment session of\n                    // the patient.  This occurs if a provider is out of town and the patient is currently waiting\n                    // for the session to start.\n\n                    if (apptReadyData.session.participantList) {\n                        patientConferenceRoom.callerSettings.participantList = apptReadyData.session.participantList;\n                        let provider = patientConferenceRoom.callerSettings.participantList.find(p => p.role == 'provider');\n                        if (!provider) {\n                            throw new Error(\"No provider in participant list.  Provider is not ready and cannot continue\");\n                        }\n                        patientConferenceRoom.callerSettings.calleeUuid = provider.uuid;\n                        patientConferenceRoom.setCurrentCallerFocusId(provider.uuid);\n                    }\n\n                    patientConferenceRoom.toggleJoinButton(patientConferenceRoom.shouldEnableJoinButton());\n                }\n            })\n            .catch(error => {\n                let errorMessage = document.querySelector('.waiting-room-server-communication');\n                if (errorMessage) {\n                    errorMessage.classList.remove(('d-none'));\n                }\n                // moving this to a console.log so we don't throw errors up in Comlink's app.\n                console.log(\"Waiting room communication error\", error);\n            });\n    }\n\n\n    patientConferenceRoom.getFullConferenceVideoBarSettings = function()\n    {\n        let settings = patientConferenceRoom.getDefaultVideoBarSettings();\n        settings.hangupCallback = patientConferenceRoom.handleCallHangup.bind(patientConferenceRoom);\n        settings.expand = false;\n        settings.notes = false; // patient doesn't get notes.\n        settings.invite = false; // patient doesn't get invite participant at least for now.\n        settings.hangup = true;\n        patientConferenceRoom.addSettingsForScreenshare(settings);\n        return settings;\n    };\n\n    patientConferenceRoom.startConferenceRoom = function()\n    {\n        patientConferenceRoom.stopProviderReadyCheck();\n        patientConferenceRoom.startProviderConferenceRoom(); // not sure there is much difference here\n\n        // we need to make a call to all the other participants...\n        let participantList = patientConferenceRoom.getRemoteParticipantList();\n        if (participantList) {\n            // if the participant is in the room, let's make a call to that user.\n            participantList.forEach(pl => {\n                if (pl.inRoom == 'Y') {\n                    patientConferenceRoom.makeCall(pl.uuid);\n                }\n            });\n        }\n    };\n\n    patientConferenceRoom.canReceiveCall = function(call) {\n        let callerId = call.getRemotePartyId();\n        console.log(\"Received call \", call);\n        // only allow calls from one of the participants allowed in the room...\n        let canCall = patientConferenceRoom.isAuthorizedParticipant(callerId);\n        return Promise.resolve({call: call, canCall: canCall});\n    };\n\n    patientConferenceRoom.handleCallEndedEvent = function(call)\n    {\n        try {\n            let detachedCallRemoteUserId = null;\n            // if the user data is allocated then this is an existing call\n            if (call.getUserData() != null) {\n\n                /**\n                 *\n                 * @type {CallerSlot|null}\n                 */\n                let callerSlot = call.getUserData();\n                detachedCallRemoteUserId = callerSlot.getRemotePartyId();\n                patientConferenceRoom.removeCallFromConference(call);\n            }\n        } catch (error) {\n            // if we have an error in removing the call... we want to for sure shut everything down if we can\n            console.error(\"Failed to remove call on call ended event\", error);\n        }\n\n        // we only fall back to the waiting room if we aren't in the middle of a session destruction.\n        if (patientConferenceRoom.inSession && !patientConferenceRoom.hasProviderParticipant()) {\n\n            // TODO: @adunsulag there must be a better spot here to reset this screenshare settings.\n            patientConferenceRoom.buttonSettings.screensharingEnabled = false;\n\n            // we shouldn't ever have the case where there are no participants but the provider is still here...\n            // for safety reasons though we want to put this in\n            alert(translations.HOST_LEFT);\n            // for patient conference if the provider leaves the call we need to send them back to the waiting room\n            patientConferenceRoom.replaceConferenceRoomWithWaitingRoom();\n            // cancel our session update sequence that happens during the conference room.\n            patientConferenceRoom.cancelConferenceRoomSessionUpdateInterval();\n        }\n    };\n\n    patientConferenceRoom.hasProviderParticipant = function() {\n        return patientConferenceRoom.findCallerSlotWithId(patientConferenceRoom.callerSettings.calleeUuid) !== undefined;\n    };\n\n    patientConferenceRoom.replaceConferenceRoomWithWaitingRoom = function()\n    {\n        // first we have to cleanup any existing slots we have\n        patientConferenceRoom.cleanupSlots();\n        let telehealthSessionData = patientConferenceRoom.telehealthSessionData;\n        let modalDialog = patientConferenceRoom.roomModal;\n        var container = document.getElementById('telehealth-container');\n        var body = container.querySelector('.modal-body');\n        var video = document.getElementById('local-video');\n\n        patientConferenceRoom.videoBar.destruct();\n        body.innerHTML = patientConferenceRoom.waitingRoomTemplate;\n        var replaceVideo = document.getElementById('local-video');\n        if (replaceVideo) {\n            replaceVideo.parentNode.replaceChild(video, replaceVideo);\n        } else {\n            console.error(\"Failed to find child video to replace\");\n            return;\n        }\n        providerIsReady = false;\n        patientConferenceRoom.initWaitingRoomEvents(container);\n        // wait five seconds before we check to see if the host has left to prevent our provider host check drift\n        hostDelayCheckTimeout = setTimeout(function() {\n            patientConferenceRoom.startProviderReadyCheck();\n        }, 5000);\n\n    };\n\n    patientConferenceRoom.handleCallHangup = function()\n    {\n        if (patientConferenceRoom.room == patientConferenceRoom.ROOM_TYPE_WAITING)\n        {\n            patientConferenceRoom.sessionClose();\n        } else {\n            // since we are already tied to the hidden event we can just hide the modal and it will destroy everything\n            // for the patient side of things.\n            if (confirm(translations.CONFIRM_SESSION_CLOSE)) {\n                patientConferenceRoom.sessionClose();\n            }\n        }\n    };\n\n    patientConferenceRoom.setWaitingRoomModal = function(waitingRoomModal)\n    {\n        patientConferenceRoom.roomModal = waitingRoomModal;\n    };\n\n    patientConferenceRoom.setupWaitingRoom = function()\n    {\n        // do the provider work and let's enable our join button only if the provider is ready\n        patientConferenceRoom.setupProviderWaitingRoom();\n        patientConferenceRoom.startProviderReadyCheck();\n    };\n    patientConferenceRoom.clearHostDelayTimeout = function() {\n        if (hostDelayCheckTimeout) {\n            clearTimeout(hostDelayCheckTimeout);\n            hostDelayCheckTimeout = null;\n        }\n    };\n    patientConferenceRoom.destruct = function()\n    {\n        patientConferenceRoom.clearHostDelayTimeout();\n        patientConferenceRoom.stopProviderReadyCheck();\n        // TODO: look at merging the two dialogs from patient versus provider\n        if (window.dlgclose) {\n            window.dlgclose();\n        }\n        parentDestruct.bind(patientConferenceRoom)();\n    };\n    patientConferenceRoom.stopProviderReadyCheck = function()\n    {\n        // in case we have a pending host delay.\n        patientConferenceRoom.clearHostDelayTimeout();\n        if (checkProviderReadyForPatientInterval) {\n            clearInterval(checkProviderReadyForPatientInterval);\n            checkProviderReadyForPatientInterval = null;\n        }\n    };\n    patientConferenceRoom.startProviderReadyCheck = function()\n    {\n        checkProviderReadyForPatientInterval = setInterval(checkProviderReadyForPatient, 2000);\n    };\n    patientConferenceRoom.shouldEnableJoinButton = function()\n    {\n        return providerIsReady && patientConferenceRoom.hasLocalPermissionsEnabled();\n    };\n    return patientConferenceRoom;\n}\n\n\n//# sourceURL=webpack://comlink-telehealth-js/./src/patient-conference-room.js?");

/***/ }),

/***/ "./src/presentation-screen.js":
/*!************************************!*\
  !*** ./src/presentation-screen.js ***!
  \************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"PresentationScreen\": function() { return /* binding */ PresentationScreen; }\n/* harmony export */ });\n/**\n * Javascript Controller for the main video screen displayed in the conference room.\n *\n * @package openemr\n * @link      http://www.open-emr.org\n * @author    Stephen Nielson <snielson@discoverandchange.com>\n * @copyright Copyright (c) 2023 Comlink Inc <https://comlinkinc.com/>\n * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3\n */\nclass PresentationScreen\n{\n    /**\n     *\n     * @type HTMLVideoElement\n     */\n    videoElement = null;\n\n    /**\n     *\n     * @type CallerSlot\n     */\n    callerSlot = null;\n\n    constructor(domNodeId)\n    {\n        /**\n         *\n         * @type HTMLVideoElement\n         */\n        this.videoElement = document.getElementById(domNodeId);\n        if (!this.videoElement) {\n            throw new Error(\"Failed to find presentation screen dom node with id \" + domNodeId);\n        }\n    }\n\n    updateCallerSlotScreen() {\n        if (this.callerSlot && this.callerSlot.getCurrentCallStream() != null) {\n            if (this.videoElement && this.callerSlot.getCurrentCallStream() != this.videoElement.srcObject) {\n                this.videoElement.srcObject = this.callerSlot.getCurrentCallStream();\n                this.videoElement.play().catch(e => console.error(\"presentation-screen failed to play updated call slot\", e));\n            }\n        }\n    }\n\n    attach(callerSlot) {\n        if (this.callerSlot != null) {\n            // nothing to do here, just return\n            if (this.callerSlot === callerSlot\n                || this.callerSlot.getRemotePartyId() == callerSlot.getRemotePartyId()) {\n                this.updateCallerSlotScreen();\n                return;\n            }\n        }\n        // if we have something let's remove it.\n        if (this.callerSlot) {\n            this.detach();\n        }\n\n        if (callerSlot && callerSlot.getCurrentCallStream() != null) {\n            let displayTitle = callerSlot.getParticipant() ? callerSlot.getParticipant().callerName : \"\";\n            this.videoElement.srcObject = callerSlot.getCurrentCallStream();\n            this.videoElement.play();\n            this.videoElement.title = displayTitle;\n            this.callerSlot = callerSlot;\n        }\n    }\n\n    hide() {\n        if (this.videoElement) {\n            this.videoElement.classList.add('d-none');\n        }\n    }\n\n    show() {\n        if (this.videoElement) {\n            this.videoElement.classList.remove('d-none');\n        }\n    }\n\n    getVideoElement() {\n        return this.videoElement;\n    }\n\n    detach() {\n        this.callerSlot = null;\n        this.videoElement.srcObject = null;\n    }\n}\n\n//# sourceURL=webpack://comlink-telehealth-js/./src/presentation-screen.js?");

/***/ }),

/***/ "./src/registration-checker.js":
/*!*************************************!*\
  !*** ./src/registration-checker.js ***!
  \*************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"RegistrationChecker\": function() { return /* binding */ RegistrationChecker; }\n/* harmony export */ });\n/**\n * Javascript function for checking the registration of the logged in user and registering them for telehealth if they\n * are not currently registered.\n *\n * @package openemr\n * @link      http://www.open-emr.org\n * @author    Stephen Nielson <snielson@discoverandchange.com>\n * @copyright Copyright (c) 2023 Comlink Inc <https://comlinkinc.com/>\n * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3\n */\nfunction RegistrationChecker(scriptLocation)\n{\n    var checker = this;\n    var timeoutId;\n    var settings;\n    var currentCheckCount = 0;\n    var maxCheck = 10;\n\n    this.checkRegistration = function()\n    {\n        if (currentCheckCount++ > maxCheck)\n        {\n            console.error(\"Failed to get a valid telehealth registration for user\");\n            return;\n        }\n\n        let location = scriptLocation + '?action=check_registration';\n\n        window.top.restoreSession();\n        window.fetch(location)\n            .then(result => {\n                if (!result.ok)\n                {\n                    throw new Error(\"Registration check failed\");\n                }\n                return result.json();\n            })\n            .then(registrationSettings => {\n                if (registrationSettings && registrationSettings.hasOwnProperty('errorCode')) {\n                    if (registrationSettings.errorCode == 402) {\n                        // user is not enrolled and so we will skip trying to register the user\n                        checker.settings = {};\n                    }\n                }\n                checker.settings = registrationSettings;\n            })\n            .catch(error => {\n                console.error(\"Failed to execute check_registration action\", error);\n                timeoutId = setTimeout(checker.checkRegistration.bind(checker), 2000);\n            });\n    };\n    return this;\n}\n\n//# sourceURL=webpack://comlink-telehealth-js/./src/registration-checker.js?");

/***/ }),

/***/ "./src/telehealth-bridge.js":
/*!**********************************!*\
  !*** ./src/telehealth-bridge.js ***!
  \**********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"TelehealthBridge\": function() { return /* binding */ TelehealthBridge; }\n/* harmony export */ });\n/* harmony import */ var _cvb_min__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cvb.min */ \"./src/cvb.min.js\");\n/**\n * Javascript Wrapper around the comlink bridge object for handling telehealth bridge interactions in the way OpenEMR\n * needs it to.\n *\n * @package openemr\n * @link      http://www.open-emr.org\n * @author    Stephen Nielson <snielson@discoverandchange.com>\n * @copyright Copyright (c) 2023 Comlink Inc <https://comlinkinc.com/>\n * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3\n */\n\n\nclass TelehealthBridge\n{\n    isShutdown = false;\n    userId = null;\n    passwordHash = null;\n    serviceUrl = null;\n    /**\n     *\n     * @type VideoBridge\n     */\n    bridge;\n\n    /**\n     *\n     * @type VideoCall\n     */\n    currentLocalScreenShareCall;\n\n    constructor(userId, passwordHash, serviceUrl) {\n        this.userId = userId;\n        this.passwordHash = passwordHash;\n        this.serviceUrl = serviceUrl;\n        this.isRunning = false;\n    }\n\n    noop() {\n    }\n\n    startBridge(handlers) {\n        handlers = handlers || {};\n        handlers.onincomingcall = handlers.onincomingcall || this.noop;\n        handlers.onbridgeactive = handlers.onbridgeactive || this.noop;\n        handlers.onbridgeinactive = handlers.onbridgeinactive || this.noop;\n        handlers.onbridgefailure = handlers.onbridgefailure || this.noop;\n\n        this.bridge = new _cvb_min__WEBPACK_IMPORTED_MODULE_0__.VideoBridge({\n            userId: this.userId,\n            passwordHash: this.passwordHash,\n            type: 'normal',\n            serviceUrl: this.serviceUrl\n        });\n        console.log(\"Instantiated bridge \"  + this.userId);\n\n\n        // Callback: incoming call\n        //\n        // When a new call comes in we'll ask the user if they want to accept or\n        // reject it.\n        this.bridge.onincomingcall = (call) => {\n            console.log(\"Receiving call from \" + call.getRemotePartyId() + \" for \"  + this.userId);\n            handlers.onincomingcall(call);\n        };\n\n        // Callback: bridge active\n        //\n        // When the bridge becomes active we'll ask it for the local media stream\n        // which we will then play in the local video element.\n        this.bridge.onbridgeactive = (bridge) => {\n            console.log(\"The bridge is active \" + this.userId);\n            handlers.onbridgeactive(bridge);\n        };\n\n        // Callback: bridge inactive\n        //\n        // When the bridge becomes inactive we'll stop the local stream video\n        // element.\n        this.bridge.onbridgeinactive = (bridge) => {\n            console.log(\"The bridge is inactive \" + this.userId);\n            handlers.onbridgeinactive(bridge);\n        };\n\n        // Callback: bridge failure\n        //\n        // Similarly, if the bridge suffers a catastrophic failure we'll stop the\n        // local stream video element.\n        this.bridge.onbridgefailure = (bridge) => {\n            console.error(\"The bridge failed \" + this.userId);\n            if (!this.isShutdown) {\n                try {\n                    // we only call this once\n                    handlers.onbridgefailure(bridge);\n                }\n                catch (e) {\n                    console.error(\"Failure occurred in bridge shutdown handler\", e);\n                }\n            }\n            this.isShutdown = true;\n            this.shutdown();\n        };\n\n        // Finally spin up the bridge.\n        this.bridge.start();\n        console.log(\"Started bridge \"  + this.userId);\n        this.isShutdown = false;\n    }\n\n    hasLocalPermissionsEnabled() {\n        if (!this.bridge) {\n            return false;\n        }\n\n        return this.bridge.hasLocalPermissionsEnabled();\n    }\n\n    shutdown() {\n        // if we are already shut down, don't need to do anything here.\n        if (!this.isShutdown) {\n            try {\n                this.bridge.shutdown();\n            }\n            catch (e) {\n                console.log(\"Error shutting down bridge\", e);\n            }\n            this.isShutdown = true;\n        }\n    }\n\n    restartMediaStream() {\n        if (this.isShutdown) {\n            console.error(\"Bridge is shutdown.  Cannot restart media stream\");\n        }\n    }\n\n    getLocalMediaStream() {\n        return this.bridge.getLocalMediaStream();\n    }\n\n    enableMicrophone(toggle) {\n        return this.bridge.enableMicrophone(toggle);\n    }\n\n    enableCamera(toggle) {\n        return this.bridge.enableCamera(toggle);\n    }\n\n    createScreenSharingCall(calleeIds) {\n        // make the first call then execute the subsequent calls\n        let call = this.bridge.createScreenSharingCall(calleeIds[0]);\n        calleeIds.shift();\n\n        let promise = call.start();\n        if (calleeIds.length <= 0) {\n            return promise.then(() => {\n                this.currentLocalScreenShareCall = call;\n                this.setScreenShareCallHandlers(call);\n                return call;\n            })\n        }\n\n        // multiparty call so we handle this differently\n        return promise.then(() => {\n            this.currentLocalScreenShareCall = call;\n            this.setScreenShareCallHandlers(call);\n\n            return Promise.all(calleeIds.map(id => {\n                let basedOnCall = this.bridge.createScreenSharingCall(id, this.currentLocalScreenShareCall);\n                this.setScreenShareCallHandlers(basedOnCall);\n                return basedOnCall.start();\n            }))\n            .then(localCalls => {\n                return this.currentLocalScreenShareCall;\n            })\n            .catch(e => {\n                if (this.currentLocalScreenShareCall) {\n                    console.log(\"multiparty screenshare failed \")\n                    this.currentLocalScreenShareCall.stop();\n                    this.currentLocalScreenShareCall = null;\n                }\n                throw e;\n            });\n        });\n    }\n\n    createVideoCall(calleeUuid) {\n        return this.bridge.createVideoCall(calleeUuid);\n    }\n\n    setCallHandlers(call) {\n        return this.bridge.setCallHandlers(call);\n    }\n\n    setScreenShareCallHandlers(call) {\n        this.currentLocalScreenShareCall.oncallended = () => {\n            this.currentLocalScreenShareCall = null;\n        };\n    }\n}\n\n\n//# sourceURL=webpack://comlink-telehealth-js/./src/telehealth-bridge.js?");

/***/ }),

/***/ "./src/telehealth.js":
/*!***************************!*\
  !*** ./src/telehealth.js ***!
  \***************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _registration_checker_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./registration-checker.js */ \"./src/registration-checker.js\");\n/* harmony import */ var _conference_room_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./conference-room.js */ \"./src/conference-room.js\");\n/* harmony import */ var _patient_conference_room_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./patient-conference-room.js */ \"./src/patient-conference-room.js\");\n\n\n\n\n\n/**\n * Core TeleHealth javascript library for communicating with OpenEMR to start and stop TeleHealth sessions.\n *\n * @package openemr\n * @link      http://www.open-emr.org\n * @author    Stephen Nielson <snielson@discoverandchange.com>\n * @copyright Copyright (c) 2022 Comlink Inc <https://comlinkinc.com/>\n * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3\n */\n\n(function(window, comlink, bootstrap, jQuery) {\n\n    /**\n     *\n     * @type {ConferenceRoom}\n     */\n    let conferenceRoom = false;\n\n    // make sure we don't error out here\n    comlink.settings = comlink.settings || {};\n\n    /**\n     * @type {string} The path of where the module is installed at.  In a multisite we pull this from the server configuration, otherwise we default here\n     */\n    let moduleLocation = comlink.settings.modulePath || '/interface/modules/custom_modules/oe-module-comlink-telehealth/';\n\n    /**\n     * @var VideoBar\n     */\n    let videoBar = null;\n\n    /**\n     * Handler from setInterval used as polling handle that checks to see if the provider has entered into the\n     * conference room and is ready to chat with the patient.\n     * @type number\n     */\n    let checkProviderReadyForPatientInterval = null;\n\n    /**\n     *\n     * @type {RegistrationChecker}\n     */\n    let checker = null;\n\n    let telehealthRegistrationInterval = null;\n\n    let registrationSettings;\n\n    let defaultTranslations = {\n        'CALL_CONNECT_FAILED': \"Failed to connect the call.\",\n        'SESSION_LAUNCH_FAILED': \"There was an error in launching your telehealth session.  Please try again or contact support\",\n        'APPOINTMENT_STATUS_UPDATE_FAILED': 'There was an error in saving the telehealth appointment status.  Please contact support or update the appointment manually in the calendar',\n        'DUPLICATE_SESSION': \"You are already in a conference session.  Please hangup the current call to start a new telehealth session\",\n        'HOST_LEFT': \"Host left the call\",\n        \"CONFIRM_SESSION_CLOSE\": \"Are you sure you want to close this session?\",\n        \"TELEHEALTH_MODAL_TITLE\": \"TeleHealth Session\",\n        \"TELEHEALTH_MODAL_CONFIRM_TITLE\": \"Confirm Session Close\",\n        \"UPDATE_APPOINTMENT_STATUS\" : \"Update appointment status\",\n        \"STATUS_NO_SHOW\" : \"No Show\",\n        \"STATUS_CANCELED\" : \"Canceled\",\n        \"STATUS_CHECKED_OUT\" : \"Checked Out\",\n        \"STATUS_SKIP_UPDATE\": \"Skip Update\",\n        \"CONFIRM\" : \"Confirm\",\n        \"STATUS_NO_UPDATE\": \"No Change\",\n        \"STATUS_OTHER\": \"Other\"\n    };\n    let translations = comlink.translations || defaultTranslations;\n\n    /**\n     * Returns the API endpoint to call for a patient or a provider for telehealth communication\n     * @param forPatient\n     */\n    function getTeleHealthScriptLocation(forPatient)\n    {\n        if (forPatient === true)\n        {\n            return moduleLocation + 'public/index-portal.php';\n        } else {\n            return moduleLocation + 'public/index.php';\n        }\n    }\n\n    function launchProviderVideoMessage(data)\n    {\n        if (conferenceRoom)\n        {\n            if (conferenceRoom.inSession) {\n                alert(translations.DUPLICATE_SESSION);\n                return;\n            }\n            else\n            {\n                // destroy the session.\n                conferenceRoom.destruct();\n                conferenceRoom = null;\n            }\n        }\n        conferenceRoom = new _conference_room_js__WEBPACK_IMPORTED_MODULE_1__.ConferenceRoom(comlink.settings.apiCSRFToken, comlink.settings.features\n            , translations, getTeleHealthScriptLocation(false));\n        conferenceRoom.init(data);\n    }\n\n    function showPatientPortalDialog(appointmentEventId) {\n            let telehealthSessionData = {\n                pc_eid: appointmentEventId\n            };\n        // we don't let patients use the local OpenEMR api so this value is empty\n        // if we at some point allow the api to be used by patients we would need to populate this.\n        let csrfToken = comlink.settings.apiCSRFToken;\n        conferenceRoom = new _patient_conference_room_js__WEBPACK_IMPORTED_MODULE_2__.PatientConferenceRoom(csrfToken, comlink.settings.features,\n            translations, getTeleHealthScriptLocation(true));\n        conferenceRoom.init(telehealthSessionData);\n    }\n\n    function launchRegistrationChecker(isPatient)\n    {\n        checker = new _registration_checker_js__WEBPACK_IMPORTED_MODULE_0__.RegistrationChecker(getTeleHealthScriptLocation(isPatient));\n        checker.checkRegistration();\n    }\n\n    // now to export our object here\n    comlink.telehealth = {\n        showPatientPortalDialog: showPatientPortalDialog,\n        launchProviderVideoMessage: launchProviderVideoMessage,\n        launchRegistrationChecker: launchRegistrationChecker,\n        getTeleHealthScriptLocation: getTeleHealthScriptLocation\n    };\n    // now reassign our comlink object or create it new if there are no other comlink extensions.\n    window.comlink = comlink;\n})(window, window.comlink || {}, bootstrap, $, window.dlgopen || function() {});\n\n\n//# sourceURL=webpack://comlink-telehealth-js/./src/telehealth.js?");

/***/ }),

/***/ "./src/video-bar-button.js":
/*!*********************************!*\
  !*** ./src/video-bar-button.js ***!
  \*********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"VideoBarButton\": function() { return /* binding */ VideoBarButton; }\n/* harmony export */ });\n/**\n * Javascript Controller for the a video bar button\n *\n * @package openemr\n * @link      http://www.open-emr.org\n * @author    Stephen Nielson <snielson@discoverandchange.com>\n * @copyright Copyright (c) 2023 Comlink Inc <https://comlinkinc.com/>\n * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3\n */\nfunction VideoBarButton(node, defaultValue, callback)\n{\n    let btn = this;\n    btn.node = node;\n    btn.value = defaultValue;\n    btn.callback = callback;\n    btn.enabled = defaultValue === true;\n\n    btn.init = function()\n    {\n        if (btn.enabled)\n        {\n            btn.attach();\n        }\n        else\n        {\n            btn.detatch();\n        }\n    };\n\n    btn.attach = function() {\n        if (this.node)\n        {\n            this.node.addEventListener('click', this.callback);\n            this.node.classList.remove('d-none');\n        }\n    };\n\n    btn.detatch = function()\n    {\n        if (this.node)\n        {\n            this.node.removeEventListener('click', this.callback);\n            this.node.classList.add('d-none');\n        }\n    };\n    btn.destruct = function()\n    {\n        // remove event handlers and cleanup memory.\n        btn.detatch();\n        btn.node = null;\n        btn.callback = null;\n    }\n    btn.toggle = function()\n    {\n        btn.enabled = !btn.enabled;\n        if (btn.enabled)\n        {\n            this.attach();\n        }\n        else\n        {\n            this.detatch();\n        }\n    };\n    btn.init();\n    return btn;\n}\n\n//# sourceURL=webpack://comlink-telehealth-js/./src/video-bar-button.js?");

/***/ }),

/***/ "./src/video-bar.js":
/*!**************************!*\
  !*** ./src/video-bar.js ***!
  \**************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"VideoBar\": function() { return /* binding */ VideoBar; }\n/* harmony export */ });\n/* harmony import */ var _video_bar_button_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./video-bar-button.js */ \"./src/video-bar-button.js\");\n/**\n * Javascript Controller for the telehealth session's control bar.\n *\n * @package openemr\n * @link      http://www.open-emr.org\n * @author    Stephen Nielson <snielson@discoverandchange.com>\n * @copyright Copyright (c) 2023 Comlink Inc <https://comlinkinc.com/>\n * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3\n */\n\n\nfunction VideoBar(container, options)\n{\n    var bar = this;\n    /**\n     * @var VideoBarButton[]\n     */\n    bar.__buttons = {};\n\n    /**\n     * @var HTMLElement\n     */\n    bar.__container = container;\n\n    function noop() {}\n\n    function init() {\n        options = options || {};\n        setDefaultValue(options,'notes', false);\n        setDefaultValue(options,'notesCallback', noop);\n\n        setDefaultValue(options,'microphone', true);\n        setDefaultValue(options,'microphoneCallback', noop);\n        setDefaultValue(options,'video', true);\n        setDefaultValue(options,'videoCallback', noop);\n        setDefaultValue(options,'expand', false);\n        setDefaultValue(options,'expandCallback', noop);\n        setDefaultValue(options,'hangup', false);\n        setDefaultValue(options,'hangupCallback', noop);\n        setDefaultValue(options,'screenshare', true);\n        setDefaultValue(options,'screenshareCallback', noop);\n        setDefaultValue(options,'invite', false);\n        setDefaultValue(options,'inviteCallback', noop);\n\n\n        let btns = ['notes', 'microphone', 'video', 'expand', 'hangup', 'screenshare', 'invite'];\n        btns.forEach(btn => {\n            let node = bar.__container.querySelector(\".telehealth-btn-\" + btn);\n            let callback = options[btn + 'Callback'] || noop;\n\n            if (!node)\n            {\n                console.error(\"Failed to find node for telehealth-btn-\" + btn);\n                return;\n            }\n            bar.__buttons[btn] = new _video_bar_button_js__WEBPACK_IMPORTED_MODULE_0__.VideoBarButton(node, options[btn], callback);\n        });\n\n        // we always make sure our microphone and video is displayed, but we swap the icons if they are disabled.\n        if (!bar.__buttons['microphone'].enabled)\n        {\n            let btn = bar.__buttons['microphone'];\n            let node = btn.node.querySelector('.fa');\n            if (btn && node) {\n                btn.toggle();\n                node.classList.add('fa-microphone-slash');\n                node.classList.remove('fa-microphone');\n            } else {\n                console.error(\"Failed to find microphone node and fa icon\");\n            }\n        }\n        if (!bar.__buttons['video'].enabled)\n        {\n            let btn = bar.__buttons['video'];\n            let node = btn.node.querySelector('.fa');\n            if (btn && node) {\n                btn.toggle();\n                node.classList.add('fa-video-slash');\n                node.classList.remove('fa-video');\n            } else {\n                console.error(\"Failed to find video node and fa icon\");\n            }\n        }\n    }\n\n    function destruct()\n    {\n        Object.values(bar.__buttons).forEach(button => button.detatch());\n        bar.__container = null;\n    }\n\n    function setDefaultValue(obj, property, value)\n    {\n        if (!obj.hasOwnProperty(property))\n        {\n            obj[property] = value;\n        }\n    }\n\n    function toggleButtons(toggleBtns)\n    {\n        toggleBtns.forEach(btn => {\n            if (bar.__buttons[btn])\n            {\n                bar.__buttons[btn].toggle();\n            }\n            else\n            {\n                console.error('Failed to find button to toggle for button ' + btn);\n            }\n\n        });\n    }\n\n\n    bar.init = init;\n    bar.destruct = destruct;\n    bar.toggleButtons = toggleButtons;\n\n    bar.init();\n    return bar;\n}\n\n//# sourceURL=webpack://comlink-telehealth-js/./src/video-bar.js?");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module can't be inlined because the eval devtool is used.
/******/ 	var __webpack_exports__ = __webpack_require__("./src/telehealth.js");
/******/ 	
/******/ })()
;