/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.dot.schemaspy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.schemaspy.output.dot.schemaspy.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public InputStream find(String parent, String name) {
        InputStream inputStream = this.findFile(parent = Objects.isNull(parent) ? "" : parent, new String[]{name});
        if (Objects.isNull(inputStream)) {
            inputStream = this.findFile(System.getProperty("user.dir"), new String[]{parent, name});
        }
        if (Objects.isNull(inputStream)) {
            inputStream = this.findFile(System.getProperty("user.home"), new String[]{parent, name});
        }
        if (Objects.isNull(inputStream)) {
            inputStream = parent.isEmpty() ? this.findClassPath(name) : this.findClassPath(parent.replaceFirst("^/", "") + "/" + name);
        }
        if (Objects.isNull(inputStream)) {
            if (parent.isEmpty()) {
                throw new ResourceNotFoundException(name);
            }
            throw new ResourceNotFoundException(parent + File.separator + name);
        }
        return inputStream;
    }

    private InputStream findFile(String first, String ... more) {
        Path path = Paths.get(first, more);
        if (path.toFile().exists()) {
            try {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException e) {
                LOGGER.debug("Couldn't read existing file: " + path.toString(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private InputStream findClassPath(String resource) {
        return this.getClass().getClassLoader().getResourceAsStream(resource);
    }
}

