/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.service.helper;

import org.schemaspy.input.dbms.service.helper.ExportForeignKey;
import org.schemaspy.input.dbms.service.helper.ImportForeignKey;
import org.schemaspy.input.dbms.xml.ForeignKeyMeta;
import org.schemaspy.input.dbms.xml.TableMeta;

public class RemoteTableIdentifier {
    private final String catalogName;
    private final String schemaName;
    private final String tableName;

    public static RemoteTableIdentifier from(ExportForeignKey foreignKey) {
        return new RemoteTableIdentifier(foreignKey.getFkTableCat(), foreignKey.getFkTableSchema(), foreignKey.getFkTableName());
    }

    public static RemoteTableIdentifier from(ImportForeignKey foreignKey) {
        return new RemoteTableIdentifier(foreignKey.getPkTableCat(), foreignKey.getPkTableSchema(), foreignKey.getPkTableName());
    }

    public static RemoteTableIdentifier from(TableMeta tableMeta) {
        return new RemoteTableIdentifier(tableMeta.getRemoteCatalog(), tableMeta.getRemoteSchema(), tableMeta.getName());
    }

    public static RemoteTableIdentifier from(ForeignKeyMeta foreignKeyMeta) {
        return new RemoteTableIdentifier(foreignKeyMeta.getRemoteCatalog(), foreignKeyMeta.getRemoteSchema(), foreignKeyMeta.getTableName());
    }

    public RemoteTableIdentifier(String catalogName, String schemaName, String tableName) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }
}

