/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.classpath;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.schemaspy.input.dbms.classpath.Classpath;

public class GetExistingUrls
implements Classpath {
    private final String path;

    public GetExistingUrls(String path) {
        this.path = path;
    }

    public Set<URI> paths() {
        String[] pieces = this.path.split(File.pathSeparator);
        Iterable files = Arrays.stream(pieces).map(File::new).collect(Collectors.toList());
        return this.consider(files);
    }

    private Set<URI> addDirectoryContent(File dir) {
        return this.consider(() -> Arrays.stream(dir.listFiles()).iterator());
    }

    private Set<URI> consider(Iterable<File> files) {
        HashSet<URI> result = new HashSet<URI>();
        for (File file : files) {
            if (!file.exists()) continue;
            result.add(file.toURI());
            if (!file.isDirectory()) continue;
            result.addAll(this.addDirectoryContent(file));
        }
        return result;
    }
}

