/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.service;

import java.lang.invoke.MethodHandles;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import org.schemaspy.input.dbms.service.ColumnService;
import org.schemaspy.input.dbms.service.SqlService;
import org.schemaspy.model.Database;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;
import org.schemaspy.model.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SqlService sqlService;
    private final Properties dbProperties;
    private final ColumnService columnService;
    private int deprecatedNagCounter = 0;

    public ViewService(SqlService sqlService, Properties dbProperties, ColumnService columnService) {
        this.sqlService = Objects.requireNonNull(sqlService);
        this.dbProperties = Objects.requireNonNull(dbProperties);
        this.columnService = Objects.requireNonNull(columnService);
    }

    public void gatherViewsDetails(Database database, View view) throws SQLException {
        this.columnService.gatherColumns((Table)view);
        if (Objects.isNull(view.getViewDefinition())) {
            this.gatherViewDefinition(database, view);
        }
        database.getViewsMap().put(view.getName(), view);
    }

    private void gatherViewDefinition(Database db, View view) throws SQLException {
        String selectViewSql = this.dbProperties.getProperty("selectViewSql");
        if (selectViewSql == null) {
            return;
        }
        try (PreparedStatement stmt = this.sqlService.prepareStatement(selectViewSql, db, view.getName());
             ResultSet resultSet = stmt.executeQuery();){
            view.setViewDefinition(this.getViewDefinitionFromResultSet(resultSet));
        }
        catch (SQLException sqlException) {
            LOGGER.error(selectViewSql);
            throw sqlException;
        }
    }

    private String getViewDefinitionFromResultSet(ResultSet resultSet) throws SQLException {
        if (this.isViewDefinitionColumnPresent(resultSet.getMetaData())) {
            return this.getFromViewDefinitionColumn(resultSet);
        }
        return this.getFromTextColumn(resultSet);
    }

    private boolean isViewDefinitionColumnPresent(ResultSetMetaData resultSetMetaData) throws SQLException {
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            if (!"view_definition".equalsIgnoreCase(resultSetMetaData.getColumnLabel(i))) continue;
            return true;
        }
        return false;
    }

    private String getFromViewDefinitionColumn(ResultSet resultSet) throws SQLException {
        StringBuilder viewDefinition = new StringBuilder();
        while (resultSet.next()) {
            viewDefinition.append(resultSet.getString("view_definition"));
        }
        return viewDefinition.toString();
    }

    private String getFromTextColumn(ResultSet resultSet) throws SQLException {
        StringBuilder viewDefinition = new StringBuilder();
        if (this.deprecatedNagCounter < 10) {
            LOGGER.warn("ColumnLabel 'text' has been deprecated and will be removed");
            ++this.deprecatedNagCounter;
        }
        while (resultSet.next()) {
            viewDefinition.append(resultSet.getString("text"));
        }
        return viewDefinition.toString();
    }

    public void gatherViewComments(Database db) {
        String sql = this.dbProperties.getProperty("selectViewCommentsSql");
        if (sql != null) {
            try (PreparedStatement stmt = this.sqlService.prepareStatement(sql, db, null);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    Table view;
                    String viewName = rs.getString("view_name");
                    if (viewName == null) {
                        viewName = rs.getString("table_name");
                    }
                    if ((view = (Table)db.getViewsMap().get(viewName)) == null) continue;
                    view.setComments(rs.getString("comments"));
                }
            }
            catch (SQLException sqlException) {
                LOGGER.warn("Failed to retrieve view comments using SQL '{}'", (Object)sql, (Object)sqlException);
            }
        }
    }

    public void gatherViewColumnComments(Database db) {
        String sql = this.dbProperties.getProperty("selectViewColumnCommentsSql");
        if (sql != null) {
            try (PreparedStatement stmt = this.sqlService.prepareStatement(sql, db, null);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    TableColumn column;
                    Table view;
                    String viewName = rs.getString("view_name");
                    if (viewName == null) {
                        viewName = rs.getString("table_name");
                    }
                    if ((view = (Table)db.getViewsMap().get(viewName)) == null || (column = view.getColumn(rs.getString("column_name"))) == null) continue;
                    column.setComments(rs.getString("comments"));
                }
            }
            catch (SQLException sqlException) {
                LOGGER.warn("Failed to retrieve view column comments using SQL '{}'", (Object)sql, (Object)sqlException);
            }
        }
    }
}

